/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.core.injector;

import com.rabbit.common.utils.ArrayUtils;
import com.rabbit.common.utils.CollectionUtils;
import com.rabbit.core.injector.IRabbitSqlInjector;
import com.rabbit.core.injector.RabbitAbstractMethod;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.builder.IncompleteElementException;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.session.Configuration;

public abstract class AbstractRabbitSqlInjector
implements IRabbitSqlInjector {
    private static final Log logger = LogFactory.getLog(AbstractRabbitSqlInjector.class);
    private Configuration configuration;
    private String currentNamespace;

    private List<ResultMap> getStatementResultMaps(String resultMap, Class<?> resultType, String statementId) {
        resultMap = this.applyCurrentNamespace(resultMap, true);
        ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
        if (resultMap != null) {
            String[] resultMapNames;
            String[] var6 = resultMapNames = resultMap.split(",");
            int var7 = resultMapNames.length;
            for (int var8 = 0; var8 < var7; ++var8) {
                String resultMapName = var6[var8];
                try {
                    resultMaps.add(this.configuration.getResultMap(resultMapName.trim()));
                    continue;
                }
                catch (IllegalArgumentException var11) {
                    throw new IncompleteElementException("Could not find result map '" + resultMapName + "' referenced from '" + statementId + "'", (Throwable)var11);
                }
            }
        } else if (resultType != null) {
            ResultMap inlineResultMap = new ResultMap.Builder(this.configuration, statementId + "-Inline", resultType, new ArrayList(), (Boolean)null).build();
            resultMaps.add(inlineResultMap);
        }
        return resultMaps;
    }

    public String applyCurrentNamespace(String base, boolean isReference) {
        if (base == null) {
            return null;
        }
        if (isReference) {
            if (base.contains(".")) {
                return base;
            }
        } else {
            if (base.startsWith(this.currentNamespace + ".")) {
                return base;
            }
            if (base.contains(".")) {
                throw new BuilderException("Dots are not allowed in element names, please remove it from " + base);
            }
        }
        return this.currentNamespace + "." + base;
    }

    @Override
    public void inspectInject(MapperBuilderAssistant builderAssistant, Class<?> mapperClass) {
        Class<?> modelClass = this.extractModelClass(mapperClass);
        List<RabbitAbstractMethod> methodList = this.getMethodList(mapperClass);
        if (CollectionUtils.isNotEmpty(methodList)) {
            methodList.forEach(m -> m.inject(builderAssistant, mapperClass, modelClass));
        } else {
            logger.debug(mapperClass.toString() + ", No effective injection method was found.");
        }
    }

    public abstract List<RabbitAbstractMethod> getMethodList(Class<?> var1);

    protected Class<?> extractModelClass(Class<?> mapperClass) {
        Type[] types = mapperClass.getGenericInterfaces();
        ParameterizedType target = null;
        Type[] var4 = types;
        int var5 = types.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            Object t;
            int var10;
            int var11;
            Type type = var4[var6];
            if (!(type instanceof ParameterizedType)) continue;
            Object[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
            if (!ArrayUtils.isNotEmpty((Object[])typeArray) || (var11 = 0) >= (var10 = typeArray.length) || (t = typeArray[var11]) instanceof TypeVariable || t instanceof WildcardType) break;
            target = (ParameterizedType)type;
            break;
        }
        return target == null ? null : (Class)target.getActualTypeArguments()[0];
    }
}

