/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.core.constructor;

import com.rabbit.core.annotation.Column;
import com.rabbit.core.bean.TableFieldInfo;
import com.rabbit.core.bean.TableInfo;
import com.rabbit.core.constructor.QueryWrapper;
import com.rabbit.core.enumation.MySqlKeyWord;
import com.rabbit.core.enumation.SqlKey;
import com.rabbit.core.parse.ParseClass2TableInfo;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateWrapper<E>
extends QueryWrapper<E>
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateWrapper.class);
    private final Map<String, Object> sqlMap = new ConcurrentHashMap<String, Object>();
    private Map<String, Object> queryWrapper = new HashMap<String, Object>(16);
    private E entity;
    private TableInfo tableInfo;

    public Map<String, Object> getQueryWrapper() {
        return this.queryWrapper;
    }

    public void setQueryWrapper(Map<String, Object> valMap) {
        this.queryWrapper.put("valMap", valMap);
    }

    public E getEntity() {
        return this.entity;
    }

    public void setEntity(E entity) {
        this.entity = entity;
    }

    public UpdateWrapper(E clazz) {
        this.tableInfo = ParseClass2TableInfo.parseClazzToTableInfo(clazz.getClass());
    }

    public UpdateWrapper() {
    }

    public Map<String, Object> sqlGenerate(Map<String, Object> mergeSqlMap) {
        Map<String, TableFieldInfo> fieldInfoMap = this.tableInfo.getColumnMap();
        this.sqlMap.put(SqlKey.TABLE_NAME.getValue(), this.tableInfo.getTableName());
        Field primaryKey = this.tableInfo.getPrimaryKey();
        TableFieldInfo columnPK = fieldInfoMap.get(primaryKey.getName());
        Map<String, String> sqlValue = this.sqlValueConvert(fieldInfoMap, primaryKey.getName());
        this.sqlMap.put(SqlKey.UPDATE_VALUE.getValue(), sqlValue);
        if (!Objects.isNull(mergeSqlMap)) {
            Map where = (Map)mergeSqlMap.get(MySqlKeyWord.WHERE.getValue());
            for (String item : where.keySet()) {
                where.put(item, ((String)where.get(item)).replace("queryWrapper.valMap", "sqlMap.UPDATE_WHERE.VALUE"));
            }
            this.sqlMap.put(SqlKey.UPDATE_WHERE.getValue(), mergeSqlMap);
        } else {
            String where = String.format("%s %s=#{objectMap.%s,jdbcType=%s}", MySqlKeyWord.WHERE.getValue(), columnPK.getColumnName(), primaryKey.getName(), columnPK.getJdbcType().getValue());
            this.sqlMap.put(SqlKey.UPDATE_WHERE.getValue(), where);
        }
        return this.sqlMap;
    }

    private Map<String, String> sqlValueConvert(Map<String, TableFieldInfo> fieldInfoMap, String pkName) {
        HashMap<String, String> paramterMap = new HashMap<String, String>();
        for (Map.Entry<String, TableFieldInfo> item : fieldInfoMap.entrySet()) {
            Column column;
            Class<?> typeHandlerClass;
            if (StringUtils.equals((CharSequence)pkName, (CharSequence)item.getKey())) continue;
            Field field = item.getValue().getField();
            String typeHandler = "";
            if (field.isAnnotationPresent(Column.class) && !StringUtils.equals((CharSequence)"Object", (CharSequence)(typeHandlerClass = (column = field.getAnnotation(Column.class)).typeHandler()).getSimpleName())) {
                typeHandler = typeHandlerClass.getName();
            }
            String propertyName = item.getValue().getPropertyName();
            String columnType = item.getValue().getJdbcType().getValue();
            String columnName = item.getValue().getColumnName();
            if (StringUtils.isNotBlank((CharSequence)typeHandler)) {
                paramterMap.put(propertyName, String.format("%s=#{objectMap.%s,typeHandler=%s},", columnName, propertyName, typeHandler));
                continue;
            }
            paramterMap.put(propertyName, String.format("%s=#{objectMap.%s,jdbcType=%s},", columnName, propertyName, columnType));
        }
        return paramterMap;
    }
}

