/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.core.constructor;

import cn.hutool.json.JSONUtil;
import com.rabbit.common.exception.MyBatisRabbitPlugException;
import com.rabbit.core.bean.TableInfo;
import com.rabbit.core.constructor.BaseAbstractWrapper;
import com.rabbit.core.enumation.MySqlColumnType;
import com.rabbit.core.enumation.MySqlKeyWord;
import com.rabbit.core.enumation.SqlKey;
import com.rabbit.core.parse.ParseClass2TableInfo;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryWrapper<E>
extends BaseAbstractWrapper<E>
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(QueryWrapper.class);
    private Map<String, String> whereSqlMap = new ConcurrentHashMap<String, String>();
    private Map<String, String> joinSqlMap = new ConcurrentHashMap<String, String>();
    private Map<String, Object> valMap = new ConcurrentHashMap<String, Object>();
    private Map<String, Object> sqlMap = new ConcurrentHashMap<String, Object>();
    private TableInfo tableInfo;
    private int joinNum = 0;
    private final String VALIDEN = "queryWrapper.valMap.";
    public static final String ASC = "ASC";
    public static final String DESC = "DESC";

    public QueryWrapper(E clazz) {
        this.tableInfo = ParseClass2TableInfo.parseClazzToTableInfo(clazz.getClass());
        this.sqlMap.put(SqlKey.TABLE_NAME.getValue(), this.tableInfo.getTableName());
    }

    public QueryWrapper() {
    }

    public QueryWrapper where(String column, Object value, String ... val) {
        this.isBlank(column);
        ++this.joinNum;
        MySqlColumnType columnType = ParseClass2TableInfo.getColumnType(value == null ? null : value.getClass());
        this.whereSqlMap.put(MySqlKeyWord.WHERE.getValue() + this.joinNum, String.format(" %s %s=#{%s,jdbcType=%s}", MySqlKeyWord.AND.getValue(), column, "queryWrapper.valMap." + column + this.joinNum, columnType.getValue()));
        this.valMap.put(column + this.joinNum, value);
        return this;
    }

    public QueryWrapper or(String column, Object value) {
        this.isBlank(column);
        ++this.joinNum;
        MySqlColumnType columnType = ParseClass2TableInfo.getColumnType(value == null ? null : value.getClass());
        this.whereSqlMap.put(MySqlKeyWord.WHERE.getValue() + this.joinNum, String.format(" %s %s=#{%s,jdbcType=%s}", MySqlKeyWord.OR.getValue(), column, "queryWrapper.valMap." + column + this.joinNum, columnType.getValue()));
        this.valMap.put(column + this.joinNum, value);
        return this;
    }

    public QueryWrapper like(String column, Object value) {
        this.isBlank(column);
        ++this.joinNum;
        MySqlColumnType columnType = ParseClass2TableInfo.getColumnType(value == null ? null : value.getClass());
        this.whereSqlMap.put(MySqlKeyWord.WHERE.getValue() + this.joinNum, String.format(" %s %s like concat('%%',#{%s,jdbcType=%s},'%%')", MySqlKeyWord.AND.getValue(), column, "queryWrapper.valMap." + column + this.joinNum, columnType.getValue()));
        this.valMap.put(column + this.joinNum, value);
        return this;
    }

    public QueryWrapper between(String column, Object begin, Object end) {
        this.isBlank(column);
        ++this.joinNum;
        MySqlColumnType columnType = ParseClass2TableInfo.getColumnType(begin == null ? null : begin.getClass());
        this.whereSqlMap.put(MySqlKeyWord.WHERE.getValue() + this.joinNum, String.format(" %s %s between #{%s,jdbcType=%s} and #{%s,jdbcType=%s}", MySqlKeyWord.AND.getValue(), column, "queryWrapper.valMap." + column + "1", columnType.getValue(), "queryWrapper.valMap." + column + "2", columnType.getValue()));
        this.valMap.put(column + "1", begin);
        this.valMap.put(column + "2", end);
        return this;
    }

    public QueryWrapper isNull(String column) {
        this.isBlank(column);
        ++this.joinNum;
        this.whereSqlMap.put(MySqlKeyWord.WHERE.getValue() + this.joinNum, String.format(" %s %s is null", MySqlKeyWord.AND.getValue(), column));
        return this;
    }

    public QueryWrapper isNotNull(String column) {
        this.isBlank(column);
        ++this.joinNum;
        this.whereSqlMap.put(MySqlKeyWord.WHERE.getValue() + this.joinNum, String.format(" %s %s is not null", MySqlKeyWord.AND.getValue(), column));
        return this;
    }

    public QueryWrapper isNullOrEqual(String column) {
        this.isBlank(column);
        ++this.joinNum;
        this.whereSqlMap.put(MySqlKeyWord.WHERE.getValue() + this.joinNum, String.format(" %s %s is null %s %s=''", MySqlKeyWord.AND.getValue(), column, MySqlKeyWord.OR.getValue(), column));
        return this;
    }

    public QueryWrapper isNotNullOrEqual(String column) {
        this.isBlank(column);
        ++this.joinNum;
        this.whereSqlMap.put(MySqlKeyWord.WHERE.getValue() + this.joinNum, String.format(" %s %s is not null %s %s<>''", MySqlKeyWord.AND.getValue(), column, MySqlKeyWord.OR.getValue(), column));
        return this;
    }

    public QueryWrapper notEqual(String column, Object value) {
        this.isBlank(column);
        ++this.joinNum;
        MySqlColumnType columnType = ParseClass2TableInfo.getColumnType(value == null ? null : value.getClass());
        this.whereSqlMap.put(MySqlKeyWord.WHERE.getValue() + this.joinNum, String.format(" %s %s<>#{%s,jdbcType=%s}", MySqlKeyWord.AND.getValue(), column, "queryWrapper.valMap." + column + this.joinNum, columnType.getValue()));
        this.valMap.put(column + this.joinNum, value);
        return this;
    }

    public QueryWrapper in(String column, Object ... values) {
        this.isBlank(column);
        this.sqlMap.put(MySqlKeyWord.IN.getValue(), String.format(" %s %s %s", MySqlKeyWord.AND.getValue(), column, MySqlKeyWord.IN.getValue()));
        this.valMap.put(MySqlKeyWord.IN.getValue(), values);
        return this;
    }

    public QueryWrapper notIn(String column, Object ... values) {
        this.isBlank(column);
        this.sqlMap.put(MySqlKeyWord.NOT.getValue() + "IN", String.format(" %s %s %s %s", MySqlKeyWord.AND.getValue(), column, MySqlKeyWord.NOT.getValue(), MySqlKeyWord.IN.getValue()));
        this.valMap.put(MySqlKeyWord.NOT.getValue() + "IN", values);
        return this;
    }

    public QueryWrapper gt(String column, Object value) {
        this.isBlank(column);
        ++this.joinNum;
        MySqlColumnType columnType = ParseClass2TableInfo.getColumnType(value == null ? null : value.getClass());
        this.whereSqlMap.put(MySqlKeyWord.WHERE.getValue() + this.joinNum, String.format(" %s %s>#{%s,jdbcType=%s}", MySqlKeyWord.AND.getValue(), column, "queryWrapper.valMap." + column + this.joinNum, columnType.getValue()));
        this.valMap.put(column + this.joinNum, value);
        return this;
    }

    public QueryWrapper lt(String column, Object value) {
        this.isBlank(column);
        ++this.joinNum;
        MySqlColumnType columnType = ParseClass2TableInfo.getColumnType(value == null ? null : value.getClass());
        this.whereSqlMap.put(MySqlKeyWord.WHERE.getValue() + this.joinNum, String.format(" %s %s<#{%s,jdbcType=%s}", MySqlKeyWord.AND.getValue(), column, "queryWrapper.valMap." + column + this.joinNum, columnType.getValue()));
        this.valMap.put(column + this.joinNum, value);
        return this;
    }

    public QueryWrapper ge(String column, Object value) {
        this.isBlank(column);
        ++this.joinNum;
        MySqlColumnType columnType = ParseClass2TableInfo.getColumnType(value == null ? null : value.getClass());
        this.whereSqlMap.put(MySqlKeyWord.WHERE.getValue() + this.joinNum, String.format(" %s %s>=#{%s,jdbcType=%s}", MySqlKeyWord.AND.getValue(), column, "queryWrapper.valMap." + column + this.joinNum, columnType.getValue()));
        this.valMap.put(column + this.joinNum, value);
        return this;
    }

    public QueryWrapper le(String column, Object value) {
        this.isBlank(column);
        ++this.joinNum;
        MySqlColumnType columnType = ParseClass2TableInfo.getColumnType(value == null ? null : value.getClass());
        this.whereSqlMap.put(MySqlKeyWord.WHERE.getValue() + this.joinNum, String.format(" %s %s<=#{%s,jdbcType=%s}", MySqlKeyWord.AND.getValue(), column, "queryWrapper.valMap." + column + this.joinNum, columnType.getValue()));
        this.valMap.put(column + this.joinNum, value);
        return this;
    }

    public QueryWrapper setColumn(String columns) {
        this.isBlank(columns);
        this.sqlMap.put("setColumn", columns);
        return this;
    }

    public QueryWrapper orderBy(String columns, String orderType) {
        this.isBlank(columns);
        this.sqlMap.put(MySqlKeyWord.ORDER_BY.getValue().replace(" ", ""), String.format(" %s %s %s", MySqlKeyWord.ORDER_BY.getValue(), columns, orderType));
        return this;
    }

    public QueryWrapper limit(int page, int limit) {
        this.sqlMap.put(MySqlKeyWord.LIMIT.getValue(), String.format(" %s %s,%s", MySqlKeyWord.LIMIT.getValue(), (page - 1) * limit, limit));
        return this;
    }

    public QueryWrapper leftJoin(String tableName, String on) {
        return this;
    }

    public QueryWrapper rightJoin(String tableName, String on) {
        return this;
    }

    public QueryWrapper innerJoin(String tableName, String on) {
        return this;
    }

    private void isBlank(String column) {
        if (StringUtils.isBlank((CharSequence)column)) {
            throw new MyBatisRabbitPlugException("\u8981\u67e5\u8be2\u7684\u5b57\u6bb5\u4e3a\u7a7a......");
        }
    }

    public Map<String, Object> mergeSqlMap() {
        this.sqlMap.put(MySqlKeyWord.WHERE.getValue(), this.whereSqlMap);
        this.sqlMap.put(MySqlKeyWord.JOINWD.getValue(), this.joinSqlMap);
        this.sqlMap.put(MySqlKeyWord.VALUE.getValue(), this.valMap);
        log.info("{}: QueryWrapper -> Sql: {}", (Object)"Mybatis-Rabbit-Plug", (Object)JSONUtil.toJsonStr(this.sqlMap));
        return this.sqlMap;
    }

    public Map<String, String> getWhereSqlMap() {
        return this.whereSqlMap;
    }

    public Map<String, String> getJoinSqlMap() {
        return this.joinSqlMap;
    }

    public Map<String, Object> getValMap() {
        return this.valMap;
    }

    public Map<String, Object> getSqlMap() {
        return this.sqlMap;
    }

    public TableInfo getTableInfo() {
        return this.tableInfo;
    }

    public int getJoinNum() {
        return this.joinNum;
    }

    public String getVALIDEN() {
        return this.VALIDEN;
    }

    public void setWhereSqlMap(Map<String, String> whereSqlMap) {
        this.whereSqlMap = whereSqlMap;
    }

    public void setJoinSqlMap(Map<String, String> joinSqlMap) {
        this.joinSqlMap = joinSqlMap;
    }

    public void setValMap(Map<String, Object> valMap) {
        this.valMap = valMap;
    }

    public void setSqlMap(Map<String, Object> sqlMap) {
        this.sqlMap = sqlMap;
    }

    public void setTableInfo(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    public void setJoinNum(int joinNum) {
        this.joinNum = joinNum;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryWrapper)) {
            return false;
        }
        QueryWrapper other = (QueryWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$whereSqlMap = this.getWhereSqlMap();
        Map<String, String> other$whereSqlMap = other.getWhereSqlMap();
        if (this$whereSqlMap == null ? other$whereSqlMap != null : !((Object)this$whereSqlMap).equals(other$whereSqlMap)) {
            return false;
        }
        Map<String, String> this$joinSqlMap = this.getJoinSqlMap();
        Map<String, String> other$joinSqlMap = other.getJoinSqlMap();
        if (this$joinSqlMap == null ? other$joinSqlMap != null : !((Object)this$joinSqlMap).equals(other$joinSqlMap)) {
            return false;
        }
        Map<String, Object> this$valMap = this.getValMap();
        Map<String, Object> other$valMap = other.getValMap();
        if (this$valMap == null ? other$valMap != null : !((Object)this$valMap).equals(other$valMap)) {
            return false;
        }
        Map<String, Object> this$sqlMap = this.getSqlMap();
        Map<String, Object> other$sqlMap = other.getSqlMap();
        if (this$sqlMap == null ? other$sqlMap != null : !((Object)this$sqlMap).equals(other$sqlMap)) {
            return false;
        }
        TableInfo this$tableInfo = this.getTableInfo();
        TableInfo other$tableInfo = other.getTableInfo();
        if (this$tableInfo == null ? other$tableInfo != null : !((Object)this$tableInfo).equals(other$tableInfo)) {
            return false;
        }
        if (this.getJoinNum() != other.getJoinNum()) {
            return false;
        }
        String this$VALIDEN = this.getVALIDEN();
        String other$VALIDEN = other.getVALIDEN();
        return !(this$VALIDEN == null ? other$VALIDEN != null : !this$VALIDEN.equals(other$VALIDEN));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $whereSqlMap = this.getWhereSqlMap();
        result = result * 59 + ($whereSqlMap == null ? 43 : ((Object)$whereSqlMap).hashCode());
        Map<String, String> $joinSqlMap = this.getJoinSqlMap();
        result = result * 59 + ($joinSqlMap == null ? 43 : ((Object)$joinSqlMap).hashCode());
        Map<String, Object> $valMap = this.getValMap();
        result = result * 59 + ($valMap == null ? 43 : ((Object)$valMap).hashCode());
        Map<String, Object> $sqlMap = this.getSqlMap();
        result = result * 59 + ($sqlMap == null ? 43 : ((Object)$sqlMap).hashCode());
        TableInfo $tableInfo = this.getTableInfo();
        result = result * 59 + ($tableInfo == null ? 43 : ((Object)$tableInfo).hashCode());
        result = result * 59 + this.getJoinNum();
        String $VALIDEN = this.getVALIDEN();
        result = result * 59 + ($VALIDEN == null ? 43 : $VALIDEN.hashCode());
        return result;
    }

    public String toString() {
        return "QueryWrapper(whereSqlMap=" + this.getWhereSqlMap() + ", joinSqlMap=" + this.getJoinSqlMap() + ", valMap=" + this.getValMap() + ", sqlMap=" + this.getSqlMap() + ", tableInfo=" + this.getTableInfo() + ", joinNum=" + this.getJoinNum() + ", VALIDEN=" + this.getVALIDEN() + ")";
    }
}

