/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.core.constructor;

import com.rabbit.core.annotation.Column;
import com.rabbit.core.annotation.Id;
import com.rabbit.core.bean.TableFieldInfo;
import com.rabbit.core.bean.TableInfo;
import com.rabbit.core.constructor.BaseAbstractWrapper;
import com.rabbit.core.enumation.MySqlKeyWord;
import com.rabbit.core.enumation.SqlKey;
import com.rabbit.core.parse.ParseClass2TableInfo;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertWrapper<E>
extends BaseAbstractWrapper<E>
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(InsertWrapper.class);
    private final Map<String, String> sqlMap = new ConcurrentHashMap<String, String>();
    private TableInfo tableInfo;

    public InsertWrapper(E clazz) {
        this.tableInfo = ParseClass2TableInfo.parseClazzToTableInfo(clazz.getClass());
    }

    public Map<String, String> sqlGenerate() {
        Map<String, TableFieldInfo> fieldInfoMap = this.tableInfo.getColumnMap();
        this.sqlMap.put(SqlKey.INSERT_HEAD.getValue(), MySqlKeyWord.INSERT.getValue());
        this.sqlMap.put(SqlKey.TABLE_NAME.getValue(), this.tableInfo.getTableName());
        this.sqlMap.put(SqlKey.INSERT_PAM_LEFT_BRA.getValue(), "(");
        Collection<TableFieldInfo> fieldInfoCollection = fieldInfoMap.values();
        this.filterIncrementColumnField(fieldInfoCollection);
        List sqlField = fieldInfoCollection.stream().map(x -> x.getColumnName()).collect(Collectors.toList());
        this.sqlMap.put(SqlKey.INSERT_PARAMETER.getValue(), String.join((CharSequence)",", sqlField));
        this.sqlMap.put(SqlKey.INSERT_PAM_RIGHT_BRA.getValue(), ")");
        this.sqlMap.put(SqlKey.INSERT_VALUE_KEYWORD.getValue(), MySqlKeyWord.VALUE.getValue());
        String sqlValue = this.sqlValueConvert(fieldInfoMap);
        this.sqlMap.put(SqlKey.INSERT_VAL_LEFT_BRA.getValue(), "(");
        this.sqlMap.put(SqlKey.INSERT_VALUE.getValue(), sqlValue);
        this.sqlMap.put(SqlKey.INSERT_VAL_RIGHT_BRA.getValue(), ");");
        return this.sqlMap;
    }

    private String sqlValueConvert(Map<String, TableFieldInfo> fieldInfoMap) {
        StringJoiner sj = new StringJoiner(",");
        for (Map.Entry<String, TableFieldInfo> item : fieldInfoMap.entrySet()) {
            Column column;
            Class<?> typeHandlerClass;
            Field field = item.getValue().getField();
            String typeHandler = "";
            if (field.isAnnotationPresent(Column.class) && !StringUtils.equals((CharSequence)"Object", (CharSequence)(typeHandlerClass = (column = field.getAnnotation(Column.class)).typeHandler()).getSimpleName())) {
                typeHandler = typeHandlerClass.getName();
            }
            String propertyName = item.getValue().getPropertyName();
            String columnType = item.getValue().getJdbcType().getValue();
            if (StringUtils.isNotBlank((CharSequence)typeHandler)) {
                sj.add(String.format("#{objectMap.%s,typeHandler=%s}", propertyName, typeHandler));
                continue;
            }
            sj.add(String.format("#{objectMap.%s,jdbcType=%s}", propertyName, columnType));
        }
        return sj.toString();
    }

    public void filterIncrementColumnField(Collection<TableFieldInfo> fieldInfoCollection) {
        Iterator<TableFieldInfo> fieldInfoIterator = fieldInfoCollection.iterator();
        while (fieldInfoIterator.hasNext()) {
            Id id;
            TableFieldInfo tableFieldInfo = fieldInfoIterator.next();
            if (!tableFieldInfo.getField().isAnnotationPresent(Id.class) || !(id = tableFieldInfo.getField().getAnnotation(Id.class)).isIncrementColumn()) continue;
            fieldInfoIterator.remove();
        }
    }
}

