/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.core.constructor;

import com.rabbit.core.annotation.Column;
import com.rabbit.core.annotation.Id;
import com.rabbit.core.bean.TableFieldInfo;
import com.rabbit.core.bean.TableInfo;
import com.rabbit.core.constructor.BaseAbstractWrapper;
import com.rabbit.core.enumation.MySqlKeyWord;
import com.rabbit.core.enumation.SqlKey;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DefaultAbstractWrapper
extends BaseAbstractWrapper {
    private TableInfo tableInfo;

    public DefaultAbstractWrapper(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    public Map<String, String> insertSqlGenerate() {
        HashMap<String, String> sqlMap = new HashMap<String, String>();
        Map<String, TableFieldInfo> fieldInfoMap = this.tableInfo.getColumnMap();
        sqlMap.put(SqlKey.INSERT_HEAD.getValue(), MySqlKeyWord.INSERT.getValue());
        sqlMap.put(SqlKey.TABLE_NAME.getValue(), this.tableInfo.getTableName());
        sqlMap.put(SqlKey.INSERT_PAM_LEFT_BRA.getValue(), "(");
        Collection<TableFieldInfo> fieldInfoCollection = fieldInfoMap.values();
        List<String> sqlField = this.filterIncrementColumnField(fieldInfoCollection);
        sqlMap.put(SqlKey.INSERT_PARAMETER.getValue(), String.join((CharSequence)",", sqlField));
        sqlMap.put(SqlKey.INSERT_PAM_RIGHT_BRA.getValue(), ")");
        sqlMap.put(SqlKey.INSERT_VALUE_KEYWORD.getValue(), MySqlKeyWord.VALUE.getValue());
        sqlMap.put(SqlKey.INSERT_VAL_LEFT_BRA.getValue(), "(");
        String sqlValue = this.sqlValueConvert(fieldInfoMap);
        sqlMap.put(SqlKey.INSERT_VALUE.getValue(), sqlValue);
        sqlMap.put(SqlKey.INSERT_VAL_RIGHT_BRA.getValue(), ");");
        return sqlMap;
    }

    public Map<String, Object> updateSqlGenerate() {
        Map<String, TableFieldInfo> fieldInfoMap = this.tableInfo.getColumnMap();
        HashMap<String, Object> sqlMap = new HashMap<String, Object>();
        sqlMap.put(SqlKey.TABLE_NAME.getValue(), this.tableInfo.getTableName());
        Field primaryKey = this.tableInfo.getPrimaryKey();
        TableFieldInfo columnPK = null;
        if (Objects.nonNull(primaryKey)) {
            columnPK = fieldInfoMap.get(primaryKey.getName());
        }
        Map<String, String> sqlValue = this.sqlValueConvert(fieldInfoMap, primaryKey == null ? "" : primaryKey.getName());
        sqlMap.put(SqlKey.UPDATE_VALUE.getValue(), sqlValue);
        if (Objects.nonNull(columnPK)) {
            String where = String.format("%s %s=#{objectMap.%s,jdbcType=%s}", MySqlKeyWord.WHERE.getValue(), columnPK.getColumnName(), primaryKey.getName(), columnPK.getJdbcType().getValue());
            sqlMap.put(SqlKey.UPDATE_WHERE.getValue(), where);
        }
        return sqlMap;
    }

    private String sqlValueConvert(Map<String, TableFieldInfo> fieldInfoMap) {
        StringJoiner values = new StringJoiner(",");
        for (Map.Entry<String, TableFieldInfo> item : fieldInfoMap.entrySet()) {
            Field field;
            StringJoiner value = new StringJoiner(",", "#{", "}");
            String propertyName = item.getValue().getPropertyName();
            value.add(String.format("%s", propertyName));
            String jdbcType = item.getValue().getJdbcType().getValue();
            if (StringUtils.isNotBlank((CharSequence)jdbcType)) {
                value.add(String.format("jdbcType=%s", jdbcType));
            }
            if ((field = item.getValue().getField()).isAnnotationPresent(Id.class)) {
                values.add(value.toString());
                continue;
            }
            Class<?> typeHandler = item.getValue().getTypeHandler();
            if (typeHandler != Object.class) {
                value.add(String.format("typeHandler=%s", typeHandler.getName()));
            }
            values.add(value.toString());
        }
        return values.toString();
    }

    private Map<String, String> sqlValueConvert(Map<String, TableFieldInfo> fieldInfoMap, String pkName) {
        HashMap<String, String> paramterMap = new HashMap<String, String>();
        for (Map.Entry<String, TableFieldInfo> item : fieldInfoMap.entrySet()) {
            Column column;
            Class<?> typeHandlerClass;
            if (StringUtils.equals((CharSequence)pkName, (CharSequence)item.getKey())) continue;
            Field field = item.getValue().getField();
            String typeHandler = "";
            if (field.isAnnotationPresent(Column.class) && !StringUtils.equals((CharSequence)"Object", (CharSequence)(typeHandlerClass = (column = field.getAnnotation(Column.class)).typeHandler()).getSimpleName())) {
                typeHandler = typeHandlerClass.getName();
            }
            String propertyName = item.getValue().getPropertyName();
            String columnType = item.getValue().getJdbcType().getValue();
            String columnName = item.getValue().getColumnName();
            if (StringUtils.isNotBlank((CharSequence)typeHandler)) {
                paramterMap.put(propertyName, String.format("%s=#{objectMap.%s,typeHandler=%s},", columnName, propertyName, typeHandler));
                continue;
            }
            paramterMap.put(propertyName, String.format("%s=#{objectMap.%s,jdbcType=%s},", columnName, propertyName, columnType));
        }
        return paramterMap;
    }

    public List<String> filterIncrementColumnField(Collection<TableFieldInfo> fieldInfoCollection) {
        return fieldInfoCollection.stream().filter(fieldInfo -> !fieldInfo.getField().isAnnotationPresent(Id.class) || !fieldInfo.getField().getAnnotation(Id.class).isIncrementColumn()).map(x -> x.getColumnName()).collect(Collectors.toList());
    }
}

