/*
 * Decompiled with CFR 0.152.
 */
package crcl.vaadin.ui;

import com.vaadin.annotations.Push;
import com.vaadin.annotations.Theme;
import com.vaadin.annotations.Widgetset;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.FileDownloader;
import com.vaadin.server.FileResource;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.server.ThemeResource;
import com.vaadin.server.VaadinRequest;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.BrowserFrame;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.Image;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.ui.CheckBox;
import com.vaadin.v7.ui.HorizontalLayout;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.ProgressBar;
import com.vaadin.v7.ui.Slider;
import com.vaadin.v7.ui.Table;
import com.vaadin.v7.ui.TextField;
import com.vaadin.v7.ui.Upload;
import com.vaadin.v7.ui.VerticalLayout;
import crcl.base.ActuateJointType;
import crcl.base.ActuateJointsType;
import crcl.base.CRCLCommandInstanceType;
import crcl.base.CRCLCommandType;
import crcl.base.CRCLProgramType;
import crcl.base.CRCLStatusType;
import crcl.base.CommandStateEnumType;
import crcl.base.CommandStatusType;
import crcl.base.EndCanonType;
import crcl.base.GetStatusType;
import crcl.base.InitCanonType;
import crcl.base.JointDetailsType;
import crcl.base.JointSpeedAccelType;
import crcl.base.JointStatusType;
import crcl.base.JointStatusesType;
import crcl.base.MessageType;
import crcl.base.MiddleCommandType;
import crcl.base.MoveToType;
import crcl.base.PointType;
import crcl.base.PoseType;
import crcl.base.SetEndEffectorType;
import crcl.base.SetTransSpeedType;
import crcl.base.StopConditionEnumType;
import crcl.base.StopMotionType;
import crcl.base.TransSpeedRelativeType;
import crcl.base.TransSpeedType;
import crcl.base.VectorType;
import crcl.utils.CRCLException;
import crcl.utils.CRCLPosemath;
import crcl.utils.CRCLSocket;
import crcl.utils.ProgramPlotter;
import crcl.vaadin.ui.CommonInfo;
import crcl.vaadin.ui.CrclClientUI;
import crcl.vaadin.ui.JogButton;
import crcl.vaadin.ui.TransformInfo;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import javax.xml.bind.JAXBException;
import rcs.posemath.PmCartesian;
import rcs.posemath.PmException;
import rcs.posemath.PmPose;
import rcs.posemath.PmQuaternion;
import rcs.posemath.PmRpy;
import rcs.posemath.Posemath;

/*
 * Exception performing whole class analysis ignored.
 */
@Theme(value="default_theme")
@Widgetset(value="crcl4java.vaadin.ui.Widgetset")
@Push
public class CrclClientUI
extends UI
implements Consumer<CommonInfo> {
    private static final List<Consumer<CommonInfo>> programInfoListeners = new ArrayList();
    private static final File REMOTE_PROGRAM_DIR = new File(System.getProperty("user.home"), ".crcl4java.programs");
    private static CommonInfo commonInfo = CommonInfo.defaultWithRemotePrograms((String[])REMOTE_PROGRAM_DIR.list());
    private static ProgramPlotter sidePlotter = new ProgramPlotter(ProgramPlotter.View.SIDE);
    private static ProgramPlotter overheadPlotter = new ProgramPlotter(ProgramPlotter.View.OVERHEAD);
    private static ProgramPlotter transformGroupSidePlotter = new ProgramPlotter(ProgramPlotter.View.SIDE);
    private static ProgramPlotter transformGroupOverheadPlotter = new ProgramPlotter(ProgramPlotter.View.OVERHEAD);
    static final File sideImageDir;
    static final File overheadImageDir;
    static final File transformGroupSideImageDir;
    static final File transformGroupOverheadImageDir;
    private static int imgcount;
    private static PoseType lastGlobalPoseInImage;
    private transient CRCLSocket socket;
    private transient Thread updateThread;
    private transient Thread monitorThread;
    private transient long lastUpdateTime = 0L;
    private transient ByteArrayOutputStream recieverOutputStream;
    private static Map<String, Resource> browserMap;
    private static final Resource defaultBrowserResource;
    private boolean running = false;
    private boolean skip_wait_for_done = false;
    private final BrowserFrame browser = new BrowserFrame("Message", defaultBrowserResource);
    private final TextField hostField = new TextField("Host");
    private final TextField portField = new TextField("Port");
    private final Button disconnectButton = new Button("Disconnect");
    private final Button connectButton = new Button("Connect");
    private final Button initButton = new Button("Init/Reset");
    final Button runButton = new Button("Run from Start");
    final Button continueButton = new Button("Continue");
    private final Table remoteProgramTable = new Table("Remote Programs");
    private final Button remoteProgramLoadButton = new Button("Load Selected Remote Program");
    private final Button remoteProgramDownloadButton = new Button("Download Selected Remote Program");
    private Resource remoteProgramResource = null;
    private FileDownloader remoteProgramDownloader = null;
    private final Table progTable = new Table("Program");
    private final Label programIndexLabel = new Label("Program Index : " + commonInfo.getProgramIndex());
    private final Label cmdIdLbl = new Label("Command ID :" + String.format("%10s", "0"));
    private final Label stateLbl = new Label("State : UNKNOWN");
    private final Label stateDescriptionLbl = new Label("");
    private String lastDescription = "";
    private final Label statusIdLbl = new Label("Status ID :" + String.format("%10s", "0"));
    private final Label holdingObjectLbl = new Label("HoldingObject : UNKNOWN");
    private final Table posCurrentTable = new Table("Current Position");
    private final Table rotCurrentTable = new Table("Current Rotation");
    private final Table posProgramTable = new Table("Program Position");
    private final Table rotProgramTable = new Table("Program Rotation");
    private final CheckBox editProgramPosCheckbox = new CheckBox("Edit Program Position");
    private final Button currentToProgamButton = new Button("Copy Current Position to Program");
    private final Button modifyProgramPositionButton = new Button("Modify Program Position");
    private final Resource defaultOverheadImageResource = new ThemeResource("overhead.jpg");
    private final Image overheadImage = new Image("Overhead", this.defaultOverheadImageResource);
    private final Resource defaultSideImageResource = new ThemeResource("side.jpg");
    private final Image sideImage = new Image("Side", this.defaultSideImageResource);
    private static File tempDir;
    private final JogButton speedMinusJB = new JogButton(" Speed-");
    private final JogButton speedPlusJB = new JogButton(" Speed+");
    private final Label speedJogLabel = new Label(" Speed: " + String.format("%+6.1f ", speedFraction * 100.0) + " % ");
    private final Button speed10Button = new Button("10% Speed");
    private final Button speed50Button = new Button("50% Speed");
    private final Button speed100Button = new Button("100% Speed");
    private final JogButton jointSpeedMinusJB = new JogButton(" Speed-");
    private final JogButton jointSpeedPlusJB = new JogButton(" Speed+");
    private final Label jointSpeedJogLabel = new Label(" Speed: " + String.format("%+6.1f ", speedFraction * 100.0) + " % ");
    private final Button jointSpeed10Button = new Button("10% Speed");
    private final Button jointSpeed50Button = new Button("50% Speed");
    private final Button jointSpeed100Button = new Button("100% Speed");
    private final Button jogIncPoint1Button = new Button(".1 mm");
    private final Button jogInc1Button = new Button("1 mm");
    private final Button jogInc10Button = new Button("10 mm");
    private final Button jogInc100Button = new Button("100 mm");
    private final Button jogInc1000Button = new Button("1m");
    private final Label jogIncLabel = new Label(" Increment: " + String.format("%+6.1f ", jogWorldTransInc) + " mm");
    final ProgressBar jogIncProgressBar = new ProgressBar(0.0f);
    private final Button jointJogIncPoint1Button = new Button(".1 deg");
    private final Button jointJogInc1Button = new Button("1 deg");
    private final Button jointJogInc10Button = new Button("10 deg");
    private final Button jointJogInc100Button = new Button("100 deg");
    public double jointJogIncrement = 10.0;
    private final Label jointJogIncLabel = new Label(" Increment: " + String.format("%+6.1f ", this.jointJogIncrement) + " deg");
    final ProgressBar jointJogIncProgressBar = new ProgressBar(0.0f);
    private final Button openGripperButton = new Button("Open Gripper");
    private final Button closeGripperButton = new Button("Close Gripper");
    private final Button recordPointButton = new Button("Record Point");
    private final JogButton xPlusJB = new JogButton(" X+ ");
    private final JogButton xMinusJB = new JogButton(" X- ");
    private final Label xJogLabel = new Label(" X: " + String.format("%+6.1f ", 0.0) + " mm ");
    private final JogButton yPlusJB = new JogButton(" Y+ ");
    private final JogButton yMinusJB = new JogButton(" Y- ");
    private final Label yJogLabel = new Label(" Y: " + String.format("%+6.1f ", 0.0) + " mm ");
    private final JogButton zPlusJB = new JogButton(" Z+ ");
    private final JogButton zMinusJB = new JogButton(" Z- ");
    private final Label zJogLabel = new Label(" Z: " + String.format("%+6.1f ", 0.0) + " mm ");
    private final JogButton rollPlusJB = new JogButton(" Roll+ ");
    private final JogButton rollMinusJB = new JogButton(" Roll- ");
    private final Label rollJogLabel = new Label(" Roll: " + String.format("%+6.1f ", 0.0) + " mm ");
    private final JogButton pitchPlusJB = new JogButton(" Pitch+ ");
    private final JogButton pitchMinusJB = new JogButton(" Pitch- ");
    private final Label pitchJogLabel = new Label(" Pitch: " + String.format("%+6.1f ", 0.0) + " mm ");
    private final JogButton yawPlusJB = new JogButton(" Yaw+ ");
    private final JogButton yawMinusJB = new JogButton(" Yaw- ");
    private final Label yawJogLabel = new Label(" Yaw: " + String.format("%+6.1f ", 0.0) + " mm ");
    private final JogButton[] jogJointPlusButtons = new JogButton[]{new JogButton("Joint1 +"), new JogButton("Joint2 +"), new JogButton("Joint3 +"), new JogButton("Joint4 +"), new JogButton("Joint5 +"), new JogButton("Joint6 +")};
    private final JogButton[] jogJointMinusButtons = new JogButton[]{new JogButton("Joint1 -"), new JogButton("Joint2 -"), new JogButton("Joint3 -"), new JogButton("Joint4 -"), new JogButton("Joint5 -"), new JogButton("Joint6 -")};
    private final Label[] jogJointLabels = new Label[]{new Label("Joint1 : " + String.format("%+6.1f ", 0.0)), new Label("Joint2 : " + String.format("%+6.1f ", 0.0)), new Label("Joint3 : " + String.format("%+6.1f ", 0.0)), new Label("Joint4 : " + String.format("%+6.1f ", 0.0)), new Label("Joint5 : " + String.format("%+6.1f ", 0.0)), new Label("Joint6 : " + String.format("%+6.1f ", 0.0))};
    private final HorizontalLayout[] jogJointLines = new HorizontalLayout[6];
    private final transient CRCLCommandInstanceType instance = new CRCLCommandInstanceType();
    private final Table transformPos1Table = new Table("First Live Position");
    private final Button setPos1CurrentButton = new Button("Set First Live Postion to Current Live Position");
    private final Table transformPos2Table = new Table("Second Live Position");
    private final Button setPos2CurrentButton = new Button("Set Second Postion to Current Live Position");
    private final Table programPos1Table = new Table("First Program Position");
    private final Button setPos1ProgramButton = new Button("Set First Program Postion to Selected Program Line");
    private final Table programPos2Table = new Table("Second Program Position");
    private final Button setPos2ProgramButton = new Button("Set Second Program Postion to Selected Program Line");
    private final Table transformTable = new Table("Computed Transform");
    private final Table point1Errors = new Table("Point 1 Errors");
    private final Table point2Errors = new Table("Point 2 Errors");
    private final Button compute2PointTransformButton = new Button("Compute Transform with Both Points");
    private final Button computePoint1TransformButton = new Button("Compute Transform with Point 1 Only");
    private final Button computePoint2TransformButton = new Button("Compute Transform with Point 2 Only");
    private final Label transformStatusLabel = new Label("Transform Notes:");
    private final Button transformProgramButton = new Button("Apply Transform To Program");
    private final Button flipXAxisButton = new Button("Flip X Axis");
    private final Label statusLabel = new Label("Status: UNITIALIZED");
    private final transient Queue<MiddleCommandType> cmdQueue = new LinkedList();
    private final Slider minXSlider = new Slider("Min X");
    private final Slider maxXSlider = new Slider("Max X");
    private final Slider minYSlider = new Slider("Min Y");
    private final Slider maxYSlider = new Slider("Max Y");
    private final Slider minZSlider = new Slider("Min Z");
    private final Slider maxZSlider = new Slider("Max Z");
    private final Resource transformGroupOverheadImageResource = new ThemeResource("overhead.jpg");
    private final Image transformGroupOverheadImage = new Image("Overhead", this.transformGroupOverheadImageResource);
    private final Resource transformGroupSideImageResource = new ThemeResource("side.jpg");
    private final Image transformGroupSideImage = new Image("Side", this.transformGroupSideImageResource);
    private final Button transformGroupResetButton = new Button("Reset");
    private final Table transformMinPosTable = new Table("Minimum");
    private final Table transformMaxPosTable = new Table("Maximum");
    private String recordPointsProgramName = null;
    private transient CRCLProgramType recordPointsProgram = null;
    private String selectedRemoteProgramFilename = null;
    private volatile boolean insideMySynAccessCount = false;
    private transient CommonInfo prevCommonInfo = CommonInfo.defaultWithRemotePrograms((String[])REMOTE_PROGRAM_DIR.list());
    public static final String VALUE_ITEM_PROPERTY = "Value";
    transient PmPose transformPm = null;
    transient PoseType transformPose = null;
    public static final String STATUS_SEPERATOR = ", ";
    private int disconnectCount = 0;
    private static double speedFraction;
    private int connectCount = -1;
    private int jogJointNumber = -1;
    private JogState curJogState = JogState.NONE;
    private JogState prevJogState = JogState.NONE;
    private transient CRCLStatusType stat = null;
    private transient PointType currentPoint = null;
    private static double jogWorldTransInc;
    private static double jogWorldRotInc;
    private transient PoseType currentPose = null;
    private static PoseType globalCurrentPose;
    private double jointJogSpeed = 5.0;
    private String lastProgramFile = null;
    private int lastProgramIndex = -1;
    private static double worldAngleIncrementRad;
    private transient MoveToType prevMoveTo = null;
    private transient ActuateJointsType prevActuateJoints = null;
    private transient long lastCmdIdSent = 1L;
    private static final Logger LOGGER;

    public static void addProgramInfoListener(Consumer<CommonInfo> l) {
        programInfoListeners.add(l);
    }

    public static void removeProgramInfoListener(Consumer<CommonInfo> l) {
        programInfoListeners.add(l);
    }

    public static void setCommonInfo(CommonInfo newCommonInfo) {
        CrclClientUI.updateImages((CommonInfo)newCommonInfo, (CommonInfo)commonInfo);
        commonInfo = newCommonInfo;
        for (Consumer l : programInfoListeners) {
            l.accept(commonInfo);
        }
    }

    public static void updateImages(CommonInfo newCommonInfo, CommonInfo oldCommonInfo) {
        if (null != newCommonInfo && null != newCommonInfo.getCurrentProgram()) {
            try {
                boolean newPose;
                boolean bl = newPose = globalCurrentPose != null && (lastGlobalPoseInImage == null || CRCLPosemath.diffPosesTran((PoseType)globalCurrentPose, (PoseType)lastGlobalPoseInImage) > 2.0);
                if (newCommonInfo.getCurrentProgram() != oldCommonInfo.getCurrentProgram() || newCommonInfo.getProgramIndex() != oldCommonInfo.getProgramIndex() || newPose) {
                    String imgCountString = String.format("%06d", ++imgcount);
                    if (null != globalCurrentPose) {
                        sidePlotter.setCurrentPoint(globalCurrentPose.getPoint());
                    }
                    BufferedImage sideImage = sidePlotter.plotProgram(newCommonInfo.getCurrentProgram(), newCommonInfo.getProgramIndex());
                    ImageIO.write((RenderedImage)sideImage, "jpg", new File(sideImageDir, "side" + CrclClientUI.currentDateString() + imgCountString + ".jpg"));
                    if (null != globalCurrentPose) {
                        overheadPlotter.setCurrentPoint(globalCurrentPose.getPoint());
                    }
                    BufferedImage overheadImage = overheadPlotter.plotProgram(newCommonInfo.getCurrentProgram(), newCommonInfo.getProgramIndex());
                    ImageIO.write((RenderedImage)overheadImage, "jpg", new File(overheadImageDir, "overhead" + CrclClientUI.currentDateString() + imgCountString + ".jpg"));
                    if (null != globalCurrentPose) {
                        lastGlobalPoseInImage = CRCLPosemath.copy((PoseType)globalCurrentPose);
                    }
                }
                String transformGroupImgCountString = String.format("%06d", ++imgcount);
                BufferedImage transformGroupSideImage = transformGroupSidePlotter.plotProgram(newCommonInfo.getCurrentProgram(), newCommonInfo.getProgramIndex());
                ImageIO.write((RenderedImage)transformGroupSideImage, "jpg", new File(transformGroupSideImageDir, "side" + CrclClientUI.currentDateString() + transformGroupImgCountString + ".jpg"));
                BufferedImage transformGroupOverheadImage = transformGroupOverheadPlotter.plotProgram(newCommonInfo.getCurrentProgram(), newCommonInfo.getProgramIndex());
                ImageIO.write((RenderedImage)transformGroupOverheadImage, "jpg", new File(transformGroupOverheadImageDir, "overhead" + CrclClientUI.currentDateString() + transformGroupImgCountString + ".jpg"));
            }
            catch (IOException ex) {
                Logger.getLogger(CrclClientUI.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private static void info(Supplier<String> messageSupplier) {
        Logger.getLogger(CrclClientUI.class.getName()).info(messageSupplier);
    }

    private static void warning(Supplier<String> messageSupplier) {
        Logger.getLogger(CrclClientUI.class.getName()).warning(messageSupplier);
    }

    public void recordCurrentPoint() {
        if (null == this.recordPointsProgram) {
            this.recordPointsProgram = new CRCLProgramType();
            InitCanonType initcmd = new InitCanonType();
            initcmd.setCommandID(1L);
            this.recordPointsProgram.setInitCanon(initcmd);
            EndCanonType endcmd = new EndCanonType();
            endcmd.setCommandID(2L);
            this.recordPointsProgram.setEndCanon(endcmd);
        }
        MoveToType moveToCmd = new MoveToType();
        PoseType pose = new PoseType();
        PointType pt = new PointType();
        pt.setX(this.currentPoint.getX());
        pt.setY(this.currentPoint.getY());
        pt.setZ(this.currentPoint.getZ());
        pose.setPoint(pt);
        VectorType xAxis = new VectorType();
        xAxis.setI(this.currentPose.getXAxis().getI());
        xAxis.setJ(this.currentPose.getXAxis().getJ());
        xAxis.setK(this.currentPose.getXAxis().getK());
        pose.setXAxis(xAxis);
        VectorType zAxis = new VectorType();
        zAxis.setI(this.currentPose.getZAxis().getI());
        zAxis.setJ(this.currentPose.getZAxis().getJ());
        zAxis.setK(this.currentPose.getZAxis().getK());
        pose.setZAxis(zAxis);
        moveToCmd.setEndPosition(pose);
        moveToCmd.setCommandID((long)(this.recordPointsProgram.getMiddleCommand().size() + 1));
        this.recordPointsProgram.getMiddleCommand().add(moveToCmd);
        this.recordPointsProgram.getEndCanon().setCommandID((long)(this.recordPointsProgram.getMiddleCommand().size() + 2));
    }

    public void recordAndSaveCurrentPoint() {
        this.recordCurrentPoint();
        this.saveRecordedPointsProgram();
    }

    public void saveRecordedPointsProgram() {
        if (null == this.recordPointsProgramName) {
            this.recordPointsProgramName = "recordedPoints." + CrclClientUI.currentDateString() + ".xml";
        }
        try (FileOutputStream fos = new FileOutputStream(new File(REMOTE_PROGRAM_DIR, this.recordPointsProgramName));){
            CRCLSocket tmpsocket = this.socket;
            if (null == tmpsocket) {
                tmpsocket = new CRCLSocket();
            }
            CRCLSocket tmpsocketf = tmpsocket;
            fos.write(tmpsocketf.programToPrettyDocString(this.recordPointsProgram, true).getBytes());
        }
        catch (IOException | JAXBException ex) {
            Logger.getLogger(CrclClientUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        CrclClientUI.setCommonInfo((CommonInfo)CommonInfo.withRemotePrograms((CommonInfo)commonInfo, (String[])REMOTE_PROGRAM_DIR.list()));
    }

    public void openGripper() {
        try {
            SetEndEffectorType seeCmd = new SetEndEffectorType();
            seeCmd.setSetting(1.0);
            long nextId = this.lastCmdIdSent + 1L;
            seeCmd.setCommandID(nextId);
            this.sendCommand((CRCLCommandType)seeCmd);
            this.recordCurrentPoint();
            this.recordPointsProgram.getMiddleCommand().add(seeCmd);
            this.saveRecordedPointsProgram();
        }
        catch (CRCLException ex) {
            Logger.getLogger(CrclClientUI.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void closeGripper() {
        try {
            SetEndEffectorType seeCmd = new SetEndEffectorType();
            seeCmd.setSetting(0.0);
            long nextId = this.lastCmdIdSent + 1L;
            seeCmd.setCommandID(nextId);
            this.sendCommand((CRCLCommandType)seeCmd);
            this.recordCurrentPoint();
            this.recordPointsProgram.getMiddleCommand().add(seeCmd);
            this.saveRecordedPointsProgram();
        }
        catch (CRCLException ex) {
            Logger.getLogger(CrclClientUI.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void loadRemotePrograms() {
        this.running = false;
        this.remoteProgramTable.removeAllItems();
        String[] remotePrograms = commonInfo.getRemotePrograms();
        if (null != remotePrograms) {
            for (int i = 0; i < remotePrograms.length; ++i) {
                String remoteProgram = remotePrograms[i];
                Item oldItem = this.remoteProgramTable.getItem((Object)i);
                if (null == oldItem) {
                    this.remoteProgramTable.addItem(new Object[]{remoteProgram}, (Object)i);
                    continue;
                }
                Property prop = oldItem.getItemProperty((Object)"File");
                prop.setValue((Object)remoteProgram);
            }
        }
    }

    private int getSelectedProgramLine() {
        Object id = this.progTable.firstItemId();
        while (id != null && id != this.progTable.lastItemId()) {
            if (this.progTable.isSelected(id)) {
                return (Integer)id;
            }
            id = this.progTable.nextItemId(id);
        }
        return -1;
    }

    private PoseType getSelectedProgramPose() {
        if (null != commonInfo && null != commonInfo.getCurrentProgram()) {
            MiddleCommandType cmd;
            CRCLProgramType program = commonInfo.getCurrentProgram();
            int program_index = this.getSelectedProgramLine();
            if (program_index > 0 && program_index <= program.getMiddleCommand().size() && (cmd = (MiddleCommandType)program.getMiddleCommand().get(program_index)) instanceof MoveToType) {
                MoveToType moveToCmd = (MoveToType)cmd;
                return moveToCmd.getEndPosition();
            }
        }
        return null;
    }

    private PointType getSelectedProgramPoint() {
        PoseType pose = this.getSelectedProgramPose();
        if (null != pose) {
            return pose.getPoint();
        }
        return null;
    }

    private void loadSelectedRemoteProgram() {
        try {
            this.running = false;
            CRCLSocket tmpsocket = this.socket;
            if (null == tmpsocket) {
                tmpsocket = new CRCLSocket();
            }
            CRCLSocket tmpsocketf = tmpsocket;
            String filename = this.selectedRemoteProgramFilename;
            File f = new File(REMOTE_PROGRAM_DIR, filename);
            this.setRemoteProgramResourceFile(f);
            String progContents = new String(Files.readAllBytes(f.toPath()));
            CRCLProgramType prog = tmpsocketf.stringToProgram(progContents, false);
            CrclClientUI.setCommonInfo((CommonInfo)CommonInfo.withNewProgram((CommonInfo)commonInfo, (String[])REMOTE_PROGRAM_DIR.list(), (String)filename, (CRCLProgramType)prog));
        }
        catch (CRCLException | IOException ex) {
            Logger.getLogger(CrclClientUI.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private synchronized void mySyncAccess(Runnable r) {
        if (this.insideMySynAccessCount) {
            System.err.println("mySyncAccess called recursively");
            Thread.dumpStack();
        }
        try {
            this.insideMySynAccessCount = true;
            this.access(r);
        }
        catch (Throwable ex) {
            Logger.getLogger(CrclClientUI.class.getName()).log(Level.SEVERE, null, ex);
            r.run();
        }
        finally {
            this.insideMySynAccessCount = false;
        }
    }

    @Override
    public void accept(CommonInfo t) {
        CRCLSocket tmpsocket = this.socket;
        if (null == tmpsocket) {
            tmpsocket = new CRCLSocket();
        }
        CRCLSocket tmpsocketf = tmpsocket;
        commonInfo = t;
        CRCLProgramType newProgram = commonInfo.getCurrentProgram();
        String currentFileName = commonInfo.getCurrentFileName();
        CRCLProgramType oldProgram = this.prevCommonInfo.getCurrentProgram();
        String oldProgramFileName = this.prevCommonInfo.getCurrentFileName();
        boolean programIsNew = newProgram != oldProgram && !currentFileName.equals(oldProgramFileName);
        String[] remotePrograms = commonInfo.getRemotePrograms();
        String[] oldRemotePrograms = this.prevCommonInfo.getRemotePrograms();
        boolean remoteProgramsNew = remotePrograms != null && remotePrograms != oldRemotePrograms && (oldRemotePrograms == null || remotePrograms.length != oldRemotePrograms.length);
        int program_index = commonInfo.getProgramIndex();
        this.mySyncAccess(() -> {
            this.programIndexLabel.setValue("Program Index :" + commonInfo.getProgramIndex());
            if (programIsNew) {
                this.progTable.removeAllItems();
                try {
                    for (int i = 0; i < newProgram.getMiddleCommand().size(); ++i) {
                        String tableCommandString = CRCLSocket.commandToSimpleString((CRCLCommandType)((CRCLCommandType)newProgram.getMiddleCommand().get(i)));
                        this.progTable.addItem(new Object[]{i, tableCommandString}, (Object)i);
                        Item item = this.progTable.getItem((Object)i);
                        item.getItemProperty((Object)"Command").setValue((Object)tableCommandString);
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(CrclClientUI.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.resetTransformGroup();
            } else {
                Item item = this.progTable.getItem((Object)program_index);
                if (null != item) {
                    this.programIndexLabel.setValue("Program Index :" + program_index);
                    this.progTable.select((Object)program_index);
                    this.progTable.setCurrentPageFirstItemId((Object)program_index);
                }
            }
            PoseType selectedProgramPose = this.getSelectedProgramPose();
            if (selectedProgramPose != null) {
                this.loadPointToTable(selectedProgramPose.getPoint(), this.posProgramTable);
                this.loadPoseToRotTable(selectedProgramPose, this.rotProgramTable);
            }
            if (remoteProgramsNew) {
                this.loadRemotePrograms();
            }
            this.continueButton.setEnabled(commonInfo.getProgramIndex() > 1);
            if (commonInfo.getTransformInfo() != this.prevCommonInfo.getTransformInfo()) {
                TransformInfo prevTransformInfo = this.prevCommonInfo.getTransformInfo();
                TransformInfo currentTransformInfo = commonInfo.getTransformInfo();
                if (prevTransformInfo.getA1() != currentTransformInfo.getA1()) {
                    this.loadPointToTable(currentTransformInfo.getA1(), this.programPos1Table);
                }
                if (prevTransformInfo.getA2() != currentTransformInfo.getA2()) {
                    this.loadPointToTable(currentTransformInfo.getA2(), this.programPos2Table);
                }
                if (prevTransformInfo.getB1() != currentTransformInfo.getB1()) {
                    this.loadPointToTable(currentTransformInfo.getB1(), this.transformPos1Table);
                }
                if (prevTransformInfo.getB2() != currentTransformInfo.getB2()) {
                    this.loadPointToTable(currentTransformInfo.getB2(), this.transformPos2Table);
                }
            }
            this.prevCommonInfo = commonInfo;
        });
        this.updateStatusLabel();
        this.checkImageDirs();
    }

    private PmCartesian getPmPointFromTable(Table tbl) {
        PmCartesian pt = new PmCartesian();
        Item xItem = tbl.getItem((Object)0);
        Property xProp = xItem.getItemProperty((Object)"Value");
        pt.x = (Double)xProp.getValue();
        Item yItem = tbl.getItem((Object)1);
        Property yProp = yItem.getItemProperty((Object)"Value");
        pt.y = (Double)yProp.getValue();
        Item zItem = tbl.getItem((Object)2);
        Property zProp = zItem.getItemProperty((Object)"Value");
        pt.z = (Double)zProp.getValue();
        return pt;
    }

    private void compute2PointTransform() {
        try {
            PmCartesian a1 = this.getPmPointFromTable(this.programPos1Table);
            PmCartesian a2 = this.getPmPointFromTable(this.programPos2Table);
            PmCartesian b1 = this.getPmPointFromTable(this.transformPos1Table);
            PmCartesian b2 = this.getPmPointFromTable(this.transformPos2Table);
            this.transformPm = CRCLPosemath.compute2DPmTransform((PmCartesian)a1, (PmCartesian)a2, (PmCartesian)b1, (PmCartesian)b2);
            this.transformPose = CRCLPosemath.toPose((PmPose)this.transformPm);
            this.loadPoseToTable(this.transformPose, this.transformTable);
            this.updateTransformErrors();
        }
        catch (CRCLException | PmException ex) {
            Logger.getLogger(CrclClientUI.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void updateTransformErrors() throws PmException {
        PmCartesian a1 = this.getPmPointFromTable(this.programPos1Table);
        PmCartesian b1 = this.getPmPointFromTable(this.transformPos1Table);
        this.updatePointErrors(a1, b1, this.point1Errors);
        PmCartesian a2 = this.getPmPointFromTable(this.programPos2Table);
        PmCartesian b2 = this.getPmPointFromTable(this.transformPos2Table);
        this.updatePointErrors(a2, b2, this.point2Errors);
        double point1_xy_distance = a1.distance(b1.x, b1.y);
        double point1_z_distance = b1.z - a1.z;
        double point2_xy_distance = a2.distance(b2.x, b2.y);
        double point2_z_distance = b2.z - a2.z;
        double xy_dist_difference = point1_xy_distance - point2_xy_distance;
        double z_dist_difference = point1_xy_distance - point2_xy_distance;
        double rotation = Math.toDegrees(Posemath.toRot((PmQuaternion)this.transformPm.rot).s);
        this.transformStatusLabel.setValue(String.format("Transform Notes: point1_xy_distance=%.3f, point2_xy_distance=%.3f, xy_dist_difference=%.3f,  point1_z_distance=%.3f, point2_z_distance=%.3f, z_dist_difference=%.3f, rotation=%.1f degrees", point1_xy_distance, point2_xy_distance, xy_dist_difference, point1_z_distance, point2_z_distance, z_dist_difference, rotation));
    }

    public void updatePointErrors(PmCartesian a, PmCartesian b, Table errorsTable) throws PmException {
        PmCartesian b1Recompute = new PmCartesian();
        Posemath.pmPoseCartMult((PmPose)this.transformPm, (PmCartesian)a, (PmCartesian)b1Recompute);
        PmCartesian point1Error = new PmCartesian();
        Posemath.pmCartCartSub((PmCartesian)b, (PmCartesian)b1Recompute, (PmCartesian)point1Error);
        this.loadPointToTable(CRCLPosemath.toPointType((PmCartesian)point1Error), errorsTable);
    }

    private void computePoint1Transform() {
        try {
            PmCartesian a1 = this.getPmPointFromTable(this.programPos1Table);
            PmCartesian b1 = this.getPmPointFromTable(this.transformPos1Table);
            this.transformPm = CRCLPosemath.compute2DPmTransform((PmCartesian)a1, (PmCartesian)a1, (PmCartesian)b1, (PmCartesian)b1);
            this.transformPose = CRCLPosemath.toPose((PmPose)this.transformPm);
            this.loadPoseToTable(this.transformPose, this.transformTable);
            this.updateTransformErrors();
        }
        catch (CRCLException | PmException ex) {
            Logger.getLogger(CrclClientUI.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void computePoint2Transform() {
        try {
            PmCartesian a2 = this.getPmPointFromTable(this.programPos2Table);
            PmCartesian b2 = this.getPmPointFromTable(this.transformPos2Table);
            this.transformPm = CRCLPosemath.compute2DPmTransform((PmCartesian)a2, (PmCartesian)a2, (PmCartesian)b2, (PmCartesian)b2);
            this.transformPose = CRCLPosemath.toPose((PmPose)this.transformPm);
            this.loadPoseToTable(this.transformPose, this.transformTable);
            this.updateTransformErrors();
        }
        catch (CRCLException | PmException ex) {
            Logger.getLogger(CrclClientUI.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static String currentDateString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'at'HHmm");
        return sdf.format(new Date());
    }

    private static boolean acceptPose(PmCartesian min, PmCartesian max, PoseType pose) {
        PointType pt = pose.getPoint();
        return pt.getX() >= min.x && pt.getX() <= max.x && pt.getY() >= min.y && pt.getY() <= max.y && pt.getZ() >= min.z && pt.getZ() <= max.z;
    }

    private void transformProgram() {
        int transformedIndex;
        CRCLSocket tmpsocket = this.socket;
        if (null == tmpsocket) {
            tmpsocket = new CRCLSocket();
        }
        CRCLSocket tmpsocketf = tmpsocket;
        this.transformPose = this.getPoseFromTable(this.transformTable);
        if (null == this.transformPose || null == commonInfo.getCurrentProgram()) {
            return;
        }
        String newProgName = commonInfo.getCurrentFileName();
        if (newProgName.endsWith(".xml")) {
            newProgName = newProgName.substring(0, newProgName.length() - 4);
        }
        if ((transformedIndex = newProgName.indexOf(".transformed")) > 0) {
            newProgName = newProgName.substring(0, transformedIndex);
        }
        newProgName = newProgName + ".transformed." + CrclClientUI.currentDateString() + ".xml";
        PmCartesian min = this.getPmPointFromTable(this.transformMinPosTable);
        PmCartesian max = this.getPmPointFromTable(this.transformMaxPosTable);
        CRCLProgramType newProgram = CRCLPosemath.transformProgramWithFilter((PoseType)this.transformPose, (CRCLProgramType)commonInfo.getCurrentProgram(), pose -> CrclClientUI.acceptPose((PmCartesian)min, (PmCartesian)max, (PoseType)pose));
        try (FileOutputStream fos = new FileOutputStream(new File(REMOTE_PROGRAM_DIR, newProgName));){
            fos.write(tmpsocketf.programToPrettyDocString(newProgram, true).getBytes());
        }
        catch (IOException | JAXBException ex) {
            Logger.getLogger(CrclClientUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        CrclClientUI.setCommonInfo((CommonInfo)CommonInfo.withNewProgram((CommonInfo)commonInfo, (String[])REMOTE_PROGRAM_DIR.list(), (String)newProgName, (CRCLProgramType)newProgram));
    }

    private void flipXAxis() {
        int flippedIndex;
        CRCLSocket tmpsocket = this.socket;
        if (null == tmpsocket) {
            tmpsocket = new CRCLSocket();
        }
        CRCLSocket tmpsocketf = tmpsocket;
        if (null == commonInfo.getCurrentProgram()) {
            return;
        }
        String newProgName = commonInfo.getCurrentFileName();
        if (newProgName.endsWith(".xml")) {
            newProgName = newProgName.substring(0, newProgName.length() - 4);
        }
        if ((flippedIndex = newProgName.indexOf(".flipped")) > 0) {
            newProgName = newProgName.substring(0, flippedIndex);
        }
        newProgName = newProgName + ".flipped." + CrclClientUI.currentDateString() + ".xml";
        CRCLProgramType newProgram = CRCLPosemath.flipXAxis((CRCLProgramType)commonInfo.getCurrentProgram());
        try (FileOutputStream fos = new FileOutputStream(new File(REMOTE_PROGRAM_DIR, newProgName));){
            fos.write(tmpsocketf.programToPrettyDocString(newProgram, true).getBytes());
        }
        catch (IOException | JAXBException ex) {
            Logger.getLogger(CrclClientUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        CrclClientUI.setCommonInfo((CommonInfo)CommonInfo.withNewProgram((CommonInfo)commonInfo, (String[])REMOTE_PROGRAM_DIR.list(), (String)newProgName, (CRCLProgramType)newProgram));
    }

    public void startRun() {
        if (null == this.socket) {
            this.connect();
        }
        CRCLProgramType program = commonInfo.getCurrentProgram();
        if (null != this.socket && null != program && program.getMiddleCommand().size() > 0) {
            try {
                if (commonInfo.getProgramIndex() < 1) {
                    CRCLCommandInstanceType instance = new CRCLCommandInstanceType();
                    instance.setCRCLCommand((CRCLCommandType)program.getInitCanon());
                    if (instance.getCRCLCommand().getCommandID() < 1L) {
                        instance.getCRCLCommand().setCommandID(1L);
                    }
                    this.socket.writeCommand(instance);
                    this.lastCmdIdSent = instance.getCRCLCommand().getCommandID();
                } else {
                    this.skip_wait_for_done = true;
                }
                this.running = true;
            }
            catch (CRCLException ex) {
                Logger.getLogger(CrclClientUI.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void setTransformA1(PointType a1) {
        CrclClientUI.setCommonInfo((CommonInfo)CommonInfo.withTransformInfoA1((CommonInfo)commonInfo, (PointType)a1));
    }

    public void setTransformA2(PointType a2) {
        CrclClientUI.setCommonInfo((CommonInfo)CommonInfo.withTransformInfoA2((CommonInfo)commonInfo, (PointType)a2));
    }

    public void setTransformB1(PointType b1) {
        CrclClientUI.setCommonInfo((CommonInfo)CommonInfo.withTransformInfoB1((CommonInfo)commonInfo, (PointType)b1));
    }

    public void setTransformB2(PointType b2) {
        CrclClientUI.setCommonInfo((CommonInfo)CommonInfo.withTransformInfoB2((CommonInfo)commonInfo, (PointType)b2));
    }

    private void currentToProgram() {
        this.loadPointToTable(this.currentPoint, this.posProgramTable);
        this.loadPoseToRotTable(this.currentPose, this.rotProgramTable);
    }

    private void saveNewProgram(CRCLProgramType newProgram) throws CRCLException {
        int modifiedIndex;
        CRCLSocket tmpsocket = this.socket;
        if (null == tmpsocket) {
            tmpsocket = new CRCLSocket();
        }
        CRCLSocket tmpsocketf = tmpsocket;
        this.transformPose = this.getPoseFromTable(this.transformTable);
        if (null == this.transformPose || null == commonInfo.getCurrentProgram()) {
            return;
        }
        String newProgName = commonInfo.getCurrentFileName();
        if (newProgName.endsWith(".xml")) {
            newProgName = newProgName.substring(0, newProgName.length() - 4);
        }
        if ((modifiedIndex = newProgName.indexOf(".modified")) > 0) {
            newProgName = newProgName.substring(0, modifiedIndex);
        }
        newProgName = newProgName + ".modified." + CrclClientUI.currentDateString() + ".xml";
        try (FileOutputStream fos = new FileOutputStream(new File(REMOTE_PROGRAM_DIR, newProgName));){
            fos.write(tmpsocketf.programToPrettyDocString(newProgram, true).getBytes());
        }
        catch (IOException | JAXBException ex) {
            Logger.getLogger(CrclClientUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        CrclClientUI.setCommonInfo((CommonInfo)CommonInfo.withNewProgram((CommonInfo)commonInfo, (String[])REMOTE_PROGRAM_DIR.list(), (String)newProgName, (CRCLProgramType)newProgram));
    }

    private void modifySelectedProgramPose() {
        if (null == commonInfo.getCurrentProgram()) {
            this.alert("No Program Selected to Modify.");
            return;
        }
        int program_index = commonInfo.getProgramIndex();
        if (program_index < 0 || program_index >= commonInfo.getCurrentProgram().getMiddleCommand().size()) {
            this.alert("Selected program index invalid.");
            return;
        }
        CRCLProgramType newProgram = CRCLPosemath.copy((CRCLProgramType)commonInfo.getCurrentProgram());
        MiddleCommandType cmd = (MiddleCommandType)newProgram.getMiddleCommand().get(commonInfo.getProgramIndex());
        if (cmd instanceof MoveToType) {
            try {
                MoveToType moveToCmd = (MoveToType)cmd;
                PoseType newPose = new PoseType();
                PointType pt = CRCLPosemath.toPointType((PmCartesian)this.getPmPointFromTable(this.posProgramTable));
                newPose.setPoint(pt);
                this.readPoseFromRotTable(newPose, this.rotProgramTable);
                moveToCmd.setEndPosition(newPose);
                newProgram.getMiddleCommand().set(program_index, cmd);
                this.saveNewProgram(newProgram);
            }
            catch (CRCLException ex) {
                Logger.getLogger(CrclClientUI.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            this.alert("Selected program command is of wrong type:" + cmd.getClass());
            return;
        }
    }

    public void alert(String msg) {
        this.mySyncAccess(() -> {
            Notification n = new Notification(msg);
            n.setDelayMsec(5000);
            n.show(Page.getCurrent());
        });
    }

    public void resetTransformGroup() {
        int i;
        this.minXSlider.setValue(Double.valueOf(this.minXSlider.getMin()));
        this.minYSlider.setValue(Double.valueOf(this.minYSlider.getMin()));
        this.minZSlider.setValue(Double.valueOf(this.minZSlider.getMin()));
        this.maxXSlider.setValue(Double.valueOf(this.maxXSlider.getMax()));
        this.maxYSlider.setValue(Double.valueOf(this.maxYSlider.getMax()));
        this.maxZSlider.setValue(Double.valueOf(this.maxZSlider.getMax()));
        for (i = 0; i < transformGroupOverheadPlotter.getSelectionMin().length; ++i) {
            CrclClientUI.transformGroupOverheadPlotter.getSelectionMin()[i] = 0.0;
        }
        for (i = 0; i < transformGroupOverheadPlotter.getSelectionMax().length; ++i) {
            CrclClientUI.transformGroupOverheadPlotter.getSelectionMax()[i] = 1.0;
        }
        for (i = 0; i < transformGroupSidePlotter.getSelectionMin().length; ++i) {
            CrclClientUI.transformGroupSidePlotter.getSelectionMin()[i] = 0.0;
        }
        for (i = 0; i < transformGroupSidePlotter.getSelectionMax().length; ++i) {
            CrclClientUI.transformGroupSidePlotter.getSelectionMax()[i] = 1.0;
        }
        this.updateTransformGroup();
    }

    public void updateTransformGroup() {
        CrclClientUI.updateImages((CommonInfo)commonInfo, (CommonInfo)commonInfo);
        if (transformGroupOverheadPlotter.hasFiniteBounds() && transformGroupSidePlotter.hasFiniteBounds()) {
            this.loadPointToTable(CRCLPosemath.toPointType((PmCartesian)new PmCartesian(transformGroupOverheadPlotter.getXMin(), transformGroupOverheadPlotter.getYMin(), transformGroupSidePlotter.getZMin())), this.transformMinPosTable);
            this.loadPointToTable(CRCLPosemath.toPointType((PmCartesian)new PmCartesian(transformGroupOverheadPlotter.getXMax(), transformGroupOverheadPlotter.getYMax(), transformGroupSidePlotter.getZMax())), this.transformMaxPosTable);
        }
        this.checkImageDirs();
    }

    private void setRemoteProgramResourceFile(File f) {
        this.remoteProgramResource = new FileResource(f);
        if (null == this.remoteProgramDownloader) {
            this.remoteProgramDownloader = new FileDownloader(this.remoteProgramResource);
            this.remoteProgramDownloader.extend((AbstractComponent)this.remoteProgramDownloadButton);
            this.remoteProgramDownloadButton.setEnabled(true);
        } else {
            this.remoteProgramDownloader.setFileDownloadResource(this.remoteProgramResource);
        }
    }

    protected void init(VaadinRequest vaadinRequest) {
        CrclClientUI.addProgramInfoListener((Consumer)this);
        VerticalLayout navLayout = new VerticalLayout();
        navLayout.setSpacing(true);
        HorizontalLayout topStatusLine = new HorizontalLayout();
        topStatusLine.setSpacing(true);
        topStatusLine.addComponent((Component)this.cmdIdLbl);
        topStatusLine.addComponent((Component)this.stateLbl);
        topStatusLine.addComponent((Component)this.stateDescriptionLbl);
        topStatusLine.addComponent((Component)this.statusIdLbl);
        topStatusLine.addComponent((Component)this.holdingObjectLbl);
        navLayout.addComponent((Component)topStatusLine);
        HorizontalLayout navButtons = new HorizontalLayout();
        navButtons.setSpacing(true);
        Button mainNavButton = new Button("Main");
        navButtons.addComponent((Component)mainNavButton);
        Button jogWorldNavButton = new Button("Jog World");
        navButtons.addComponent((Component)jogWorldNavButton);
        Button jogJointNavButton = new Button("Jog Joint");
        navButtons.addComponent((Component)jogJointNavButton);
        Button remoteProgramsNavButton = new Button("Remote Programs");
        navButtons.addComponent((Component)remoteProgramsNavButton);
        Button transformNavButton = new Button("Transform");
        navButtons.addComponent((Component)transformNavButton);
        navLayout.addComponent((Component)navButtons);
        Panel panel = new Panel();
        navLayout.addComponent((Component)panel);
        HorizontalLayout mainLayout = new HorizontalLayout();
        HorizontalLayout jogJointLayout = new HorizontalLayout();
        HorizontalLayout jogWorldLayout = new HorizontalLayout();
        VerticalLayout jogWorldLeftLayout = new VerticalLayout();
        VerticalLayout jogWorldRightLayout = new VerticalLayout();
        VerticalLayout jogJointLeftLayout = new VerticalLayout();
        VerticalLayout jogJointRightLayout = new VerticalLayout();
        VerticalLayout remoteProgramsLayout = new VerticalLayout();
        VerticalLayout transformLayout = new VerticalLayout();
        mainLayout.setSpacing(true);
        jogJointLayout.setSpacing(true);
        jogWorldLayout.setSpacing(true);
        jogJointNavButton.addClickListener((Button.ClickListener & Serializable)l -> panel.setContent((Component)jogJointLayout));
        jogWorldNavButton.addClickListener((Button.ClickListener & Serializable)l -> panel.setContent((Component)jogWorldLayout));
        mainNavButton.addClickListener((Button.ClickListener & Serializable)l -> panel.setContent((Component)mainLayout));
        remoteProgramsNavButton.addClickListener((Button.ClickListener & Serializable)l -> panel.setContent((Component)remoteProgramsLayout));
        transformNavButton.addClickListener((Button.ClickListener & Serializable)l -> panel.setContent((Component)transformLayout));
        panel.setContent((Component)mainLayout);
        mainLayout.setMargin(true);
        this.setContent((Component)navLayout);
        VerticalLayout leftLayout = new VerticalLayout();
        mainLayout.addComponent((Component)leftLayout);
        VerticalLayout middleLayout = new VerticalLayout();
        mainLayout.addComponent((Component)middleLayout);
        middleLayout.setMargin(true);
        this.setupPosTable(this.posCurrentTable);
        this.setupRotTable(this.rotCurrentTable);
        HorizontalLayout imageLine = new HorizontalLayout();
        imageLine.setSpacing(true);
        imageLine.addComponent((Component)this.overheadImage);
        imageLine.addComponent((Component)this.sideImage);
        middleLayout.addComponent((Component)imageLine);
        HorizontalLayout posRotateLine = new HorizontalLayout();
        posRotateLine.setSpacing(true);
        posRotateLine.addComponent((Component)this.posCurrentTable);
        posRotateLine.addComponent((Component)this.rotCurrentTable);
        middleLayout.addComponent((Component)posRotateLine);
        this.setupPosTable(this.posProgramTable);
        this.setupRotTable(this.rotProgramTable);
        HorizontalLayout posProgramRotateLine = new HorizontalLayout();
        posProgramRotateLine.setSpacing(true);
        posProgramRotateLine.addComponent((Component)this.posProgramTable);
        posProgramRotateLine.addComponent((Component)this.rotProgramTable);
        middleLayout.addComponent((Component)posProgramRotateLine);
        this.editProgramPosCheckbox.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> {
            this.posProgramTable.setEditable(((Boolean)this.editProgramPosCheckbox.getValue()).booleanValue());
            this.rotProgramTable.setEditable(((Boolean)this.editProgramPosCheckbox.getValue()).booleanValue());
        });
        middleLayout.addComponent((Component)this.editProgramPosCheckbox);
        this.currentToProgamButton.addClickListener((Button.ClickListener & Serializable)e -> this.currentToProgram());
        middleLayout.addComponent((Component)this.currentToProgamButton);
        this.modifyProgramPositionButton.addClickListener((Button.ClickListener & Serializable)e -> this.modifySelectedProgramPose());
        middleLayout.addComponent((Component)this.modifyProgramPositionButton);
        middleLayout.addComponent((Component)this.programIndexLabel);
        HorizontalLayout hostPortLine = new HorizontalLayout();
        hostPortLine.setSpacing(true);
        this.hostField.setValue("localhost");
        hostPortLine.addComponent((Component)this.hostField);
        this.portField.setValue("64444");
        hostPortLine.addComponent((Component)this.portField);
        leftLayout.addComponent((Component)hostPortLine);
        this.disconnectButton.setEnabled(false);
        HorizontalLayout connectDisconnectLayout = new HorizontalLayout();
        connectDisconnectLayout.addComponent((Component)this.disconnectButton);
        connectDisconnectLayout.addComponent((Component)this.connectButton);
        navButtons.addComponent((Component)this.initButton);
        leftLayout.addComponent((Component)connectDisconnectLayout);
        Upload uploadProgram = new Upload("Upload Program", (Upload.Receiver)new /* Unavailable Anonymous Inner Class!! */);
        this.remoteProgramTable.addContainerProperty((Object)"File", String.class, null);
        this.remoteProgramTable.setWidth("500px");
        this.remoteProgramTable.setHeight("460px");
        this.remoteProgramTable.setMultiSelect(false);
        this.remoteProgramTable.setSelectable(true);
        this.loadRemotePrograms();
        this.remoteProgramLoadButton.addClickListener((Button.ClickListener & Serializable)e -> this.loadSelectedRemoteProgram());
        this.progTable.addContainerProperty((Object)"Index", Integer.class, null);
        this.progTable.addContainerProperty((Object)"Command", String.class, null);
        this.progTable.setWidth("400px");
        this.progTable.setHeight("460px");
        this.progTable.setMultiSelect(false);
        this.progTable.setSelectable(true);
        this.progTable.addItemClickListener((ItemClickEvent.ItemClickListener & Serializable)e -> CrclClientUI.setCommonInfo((CommonInfo)CommonInfo.withProgramIndex((CommonInfo)commonInfo, (int)((Integer)e.getItemId()))));
        VerticalLayout transformSetupLayout = new VerticalLayout();
        VerticalLayout transformGroupLayout = new VerticalLayout();
        Panel transformPanel = new Panel();
        Button transformSetupNavButton = new Button("Setup");
        Button transformGroupNavButton = new Button("Group");
        HorizontalLayout transformNavButtonLayout = new HorizontalLayout();
        transformNavButtonLayout.setSpacing(true);
        transformNavButtonLayout.addComponent((Component)transformSetupNavButton);
        transformNavButtonLayout.addComponent((Component)transformGroupNavButton);
        transformLayout.addComponent((Component)transformNavButtonLayout);
        transformLayout.addComponent((Component)transformPanel);
        transformSetupNavButton.addClickListener((Button.ClickListener & Serializable)l -> transformPanel.setContent((Component)transformSetupLayout));
        transformGroupNavButton.addClickListener((Button.ClickListener & Serializable)l -> transformPanel.setContent((Component)transformGroupLayout));
        GridLayout posGridLayout = new GridLayout(2, 2);
        posGridLayout.setSpacing(true);
        VerticalLayout livePos1VLayout = new VerticalLayout();
        this.setupPosTable(this.transformPos1Table);
        livePos1VLayout.addComponent((Component)this.transformPos1Table);
        this.setPos1CurrentButton.addClickListener((Button.ClickListener & Serializable)e -> this.setTransformB1(this.currentPoint));
        livePos1VLayout.addComponent((Component)this.setPos1CurrentButton);
        posGridLayout.addComponent((Component)livePos1VLayout, 0, 0);
        VerticalLayout livePos2VLayout = new VerticalLayout();
        this.setupPosTable(this.transformPos2Table);
        livePos2VLayout.addComponent((Component)this.transformPos2Table);
        this.setPos2CurrentButton.addClickListener((Button.ClickListener & Serializable)e -> this.setTransformB2(this.currentPoint));
        livePos2VLayout.addComponent((Component)this.setPos2CurrentButton);
        posGridLayout.addComponent((Component)livePos2VLayout, 1, 0);
        VerticalLayout programPos1VLayout = new VerticalLayout();
        this.setupPosTable(this.programPos1Table);
        programPos1VLayout.addComponent((Component)this.programPos1Table);
        this.setPos1ProgramButton.addClickListener((Button.ClickListener & Serializable)e -> this.setTransformA1(this.getSelectedProgramPoint()));
        programPos1VLayout.addComponent((Component)this.setPos1ProgramButton);
        posGridLayout.addComponent((Component)programPos1VLayout, 0, 1);
        VerticalLayout programPos2VLayout = new VerticalLayout();
        this.setupPosTable(this.programPos2Table);
        programPos2VLayout.addComponent((Component)this.programPos2Table);
        this.setPos2ProgramButton.addClickListener((Button.ClickListener & Serializable)e -> this.setTransformA2(this.getSelectedProgramPoint()));
        programPos2VLayout.addComponent((Component)this.setPos2ProgramButton);
        posGridLayout.addComponent((Component)programPos2VLayout, 1, 1);
        transformSetupLayout.addComponent((Component)posGridLayout);
        this.setupTransformTable(this.transformTable);
        this.setupPosTable(this.point1Errors);
        this.setupPosTable(this.point2Errors);
        HorizontalLayout transformButtonsLine = new HorizontalLayout();
        transformButtonsLine.setSpacing(true);
        this.compute2PointTransformButton.addClickListener((Button.ClickListener & Serializable)e -> this.compute2PointTransform());
        transformButtonsLine.addComponent((Component)this.compute2PointTransformButton);
        this.computePoint1TransformButton.addClickListener((Button.ClickListener & Serializable)e -> this.computePoint1Transform());
        transformButtonsLine.addComponent((Component)this.computePoint1TransformButton);
        this.computePoint2TransformButton.addClickListener((Button.ClickListener & Serializable)e -> this.computePoint2Transform());
        transformButtonsLine.addComponent((Component)this.computePoint2TransformButton);
        transformSetupLayout.addComponent((Component)transformButtonsLine);
        transformSetupLayout.addComponent((Component)this.transformStatusLabel);
        HorizontalLayout outputTablesLine = new HorizontalLayout();
        outputTablesLine.setSpacing(true);
        outputTablesLine.addComponent((Component)this.transformTable);
        outputTablesLine.addComponent((Component)this.point1Errors);
        outputTablesLine.addComponent((Component)this.point2Errors);
        transformSetupLayout.addComponent((Component)outputTablesLine);
        CheckBox editable = new CheckBox("Editable", false);
        editable.addValueChangeListener((Property.ValueChangeListener & Serializable)valueChange -> this.transformTable.setEditable(((Boolean)editable.getValue()).booleanValue()));
        transformSetupLayout.addComponent((Component)editable);
        HorizontalLayout applyLine = new HorizontalLayout();
        applyLine.addComponent((Component)this.transformProgramButton);
        this.transformProgramButton.addClickListener((Button.ClickListener & Serializable)e -> this.transformProgram());
        applyLine.addComponent((Component)this.flipXAxisButton);
        this.flipXAxisButton.addClickListener((Button.ClickListener & Serializable)e -> this.flipXAxis());
        transformSetupLayout.addComponent((Component)applyLine);
        transformPanel.setContent((Component)transformSetupLayout);
        HorizontalLayout transformGroupImageLine = new HorizontalLayout();
        transformGroupImageLine.setSpacing(true);
        transformGroupImageLine.addComponent((Component)this.transformGroupOverheadImage);
        transformGroupImageLine.addComponent((Component)this.transformGroupSideImage);
        transformGroupLayout.addComponent((Component)transformGroupImageLine);
        HorizontalLayout transformGroupLowerLayout = new HorizontalLayout();
        VerticalLayout transformGroupLowerLeftLayout = new VerticalLayout();
        VerticalLayout transformGroupLowerRightLayout = new VerticalLayout();
        this.minXSlider.addListener((Component.Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.maxXSlider.addListener((Component.Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.minYSlider.addListener((Component.Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.maxYSlider.addListener((Component.Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.minZSlider.addListener((Component.Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.maxZSlider.addListener((Component.Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.minXSlider.setWidth("600px");
        transformGroupLowerLeftLayout.addComponent((Component)this.minXSlider);
        this.maxXSlider.setWidth("600px");
        this.maxXSlider.setValue(Double.valueOf(100.0));
        transformGroupLowerLeftLayout.addComponent((Component)this.maxXSlider);
        this.minYSlider.setWidth("600px");
        transformGroupLowerLeftLayout.addComponent((Component)this.minYSlider);
        this.maxYSlider.setWidth("600px");
        this.maxYSlider.setValue(Double.valueOf(100.0));
        transformGroupLowerLeftLayout.addComponent((Component)this.maxYSlider);
        this.minZSlider.setWidth("600px");
        transformGroupLowerLeftLayout.addComponent((Component)this.minZSlider);
        this.maxZSlider.setWidth("600px");
        this.maxZSlider.setValue(Double.valueOf(100.0));
        transformGroupLowerLeftLayout.addComponent((Component)this.maxZSlider);
        transformGroupLowerLayout.addComponent((Component)transformGroupLowerLeftLayout);
        this.setupPosTable(this.transformMinPosTable);
        transformGroupLowerRightLayout.addComponent((Component)this.transformMinPosTable);
        this.setupPosTable(this.transformMaxPosTable);
        transformGroupLowerRightLayout.addComponent((Component)this.transformMaxPosTable);
        transformGroupLowerLayout.addComponent((Component)transformGroupLowerRightLayout);
        transformGroupLayout.addComponent((Component)transformGroupLowerLayout);
        this.transformGroupResetButton.addClickListener((Button.ClickListener & Serializable)e -> this.resetTransformGroup());
        transformGroupLayout.addComponent((Component)this.transformGroupResetButton);
        this.runButton.addClickListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.continueButton.addClickListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.progTable.addItemClickListener((ItemClickEvent.ItemClickListener & Serializable)event -> {
            Resource r;
            String cmd = event.getItem().getItemProperty((Object)"Command").getValue().toString();
            int spaceindex = cmd.indexOf(32);
            if (spaceindex > 0) {
                cmd = cmd.substring(0, spaceindex);
            }
            if (null != (r = (Resource)browserMap.get(cmd))) {
                this.mySyncAccess(() -> this.browser.setSource(r));
            } else {
                this.mySyncAccess(() -> this.browser.setSource(defaultBrowserResource));
            }
        });
        uploadProgram.addSucceededListener((Upload.SucceededListener)new /* Unavailable Anonymous Inner Class!! */);
        this.connectButton.addClickListener((Button.ClickListener & Serializable)event -> this.connect());
        this.initButton.addClickListener((Button.ClickListener & Serializable)event -> {
            try {
                this.sendInit();
                this.cmdQueue.clear();
                SetTransSpeedType setSpeedCmd = new SetTransSpeedType();
                TransSpeedRelativeType relSpeed = new TransSpeedRelativeType();
                relSpeed.setFraction(speedFraction);
                setSpeedCmd.setTransSpeed((TransSpeedType)relSpeed);
                this.cmdQueue.offer(setSpeedCmd);
                this.running = false;
            }
            catch (CRCLException ex) {
                Logger.getLogger(CrclClientUI.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        this.disconnectButton.addClickListener((Button.ClickListener & Serializable)event -> this.disconnect());
        leftLayout.addComponent((Component)uploadProgram);
        HorizontalLayout runStopLayout = new HorizontalLayout();
        runStopLayout.addComponent((Component)this.runButton);
        runStopLayout.addComponent((Component)this.continueButton);
        Button stepButton = new Button("Step");
        stepButton.addClickListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        runStopLayout.addComponent((Component)stepButton);
        Button stopButton = new Button("Stop");
        stopButton.addClickListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        navButtons.addComponent((Component)stopButton);
        leftLayout.addComponent((Component)runStopLayout);
        this.remoteProgramTable.addItemClickListener((ItemClickEvent.ItemClickListener)new /* Unavailable Anonymous Inner Class!! */);
        remoteProgramsLayout.addComponent((Component)this.remoteProgramTable);
        HorizontalLayout remoteButtonsLine = new HorizontalLayout();
        this.remoteProgramDownloadButton.setEnabled(false);
        remoteButtonsLine.addComponent((Component)this.remoteProgramLoadButton);
        remoteButtonsLine.addComponent((Component)this.remoteProgramDownloadButton);
        remoteProgramsLayout.addComponent((Component)remoteButtonsLine);
        leftLayout.addComponent((Component)this.progTable);
        HorizontalLayout xLine = new HorizontalLayout();
        xLine.setDefaultComponentAlignment(Alignment.MIDDLE_CENTER);
        xLine.addComponent((Component)this.xMinusJB);
        this.xMinusJB.addMouseDownConsumer(med -> {
            this.curJogState = JogState.X_MINUS;
        });
        this.xMinusJB.addMouseUpConsumer(med -> this.stopMotion());
        this.xPlusJB.addMouseDownConsumer(med -> {
            this.curJogState = JogState.X_PLUS;
        });
        this.xPlusJB.addMouseUpConsumer(med -> this.stopMotion());
        xLine.addComponent((Component)this.xPlusJB);
        xLine.addComponent((Component)this.xJogLabel);
        jogWorldLeftLayout.addComponent((Component)xLine);
        HorizontalLayout yLine = new HorizontalLayout();
        yLine.setDefaultComponentAlignment(Alignment.MIDDLE_CENTER);
        yLine.addComponent((Component)this.yMinusJB);
        this.yMinusJB.addMouseDownConsumer(med -> {
            this.curJogState = JogState.Y_MINUS;
        });
        this.yMinusJB.addMouseUpConsumer(med -> this.stopMotion());
        this.yPlusJB.addMouseDownConsumer(med -> {
            this.curJogState = JogState.Y_PLUS;
        });
        this.yPlusJB.addMouseUpConsumer(med -> this.stopMotion());
        yLine.addComponent((Component)this.yPlusJB);
        yLine.addComponent((Component)this.yJogLabel);
        jogWorldLeftLayout.addComponent((Component)yLine);
        HorizontalLayout zLine = new HorizontalLayout();
        zLine.setDefaultComponentAlignment(Alignment.MIDDLE_CENTER);
        zLine.addComponent((Component)this.zMinusJB);
        this.zMinusJB.addMouseDownConsumer(med -> {
            this.curJogState = JogState.Z_MINUS;
        });
        this.zMinusJB.addMouseUpConsumer(med -> this.stopMotion());
        this.zPlusJB.addMouseDownConsumer(med -> {
            this.curJogState = JogState.Z_PLUS;
        });
        this.zPlusJB.addMouseUpConsumer(med -> this.stopMotion());
        zLine.addComponent((Component)this.zPlusJB);
        zLine.addComponent((Component)this.zJogLabel);
        jogWorldLeftLayout.addComponent((Component)zLine);
        HorizontalLayout rollLine = new HorizontalLayout();
        rollLine.setDefaultComponentAlignment(Alignment.MIDDLE_CENTER);
        rollLine.addComponent((Component)this.rollMinusJB);
        this.rollMinusJB.addMouseDownConsumer(med -> {
            this.curJogState = JogState.ROLL_MINUS;
        });
        this.rollMinusJB.addMouseUpConsumer(med -> this.stopMotion());
        this.rollPlusJB.addMouseDownConsumer(med -> {
            this.curJogState = JogState.ROLL_PLUS;
        });
        this.rollPlusJB.addMouseUpConsumer(med -> this.stopMotion());
        rollLine.addComponent((Component)this.rollPlusJB);
        rollLine.addComponent((Component)this.rollJogLabel);
        jogWorldLeftLayout.addComponent((Component)rollLine);
        HorizontalLayout pitchLine = new HorizontalLayout();
        pitchLine.setDefaultComponentAlignment(Alignment.MIDDLE_CENTER);
        pitchLine.addComponent((Component)this.pitchMinusJB);
        this.pitchMinusJB.addMouseDownConsumer(med -> {
            this.curJogState = JogState.PITCH_MINUS;
        });
        this.pitchMinusJB.addMouseUpConsumer(med -> this.stopMotion());
        this.pitchPlusJB.addMouseDownConsumer(med -> {
            this.curJogState = JogState.PITCH_PLUS;
        });
        this.pitchPlusJB.addMouseUpConsumer(med -> this.stopMotion());
        pitchLine.addComponent((Component)this.pitchPlusJB);
        pitchLine.addComponent((Component)this.pitchJogLabel);
        jogWorldLeftLayout.addComponent((Component)pitchLine);
        HorizontalLayout yawLine = new HorizontalLayout();
        yawLine.setDefaultComponentAlignment(Alignment.MIDDLE_CENTER);
        yawLine.addComponent((Component)this.yawMinusJB);
        this.yawMinusJB.addMouseDownConsumer(med -> {
            this.curJogState = JogState.YAW_MINUS;
        });
        this.yawMinusJB.addMouseUpConsumer(med -> this.stopMotion());
        this.yawPlusJB.addMouseDownConsumer(med -> {
            this.curJogState = JogState.YAW_PLUS;
        });
        this.yawPlusJB.addMouseUpConsumer(med -> this.stopMotion());
        yawLine.addComponent((Component)this.yawPlusJB);
        yawLine.addComponent((Component)this.yawJogLabel);
        jogWorldLeftLayout.addComponent((Component)yawLine);
        jogWorldLayout.addComponent((Component)jogWorldLeftLayout);
        HorizontalLayout speedLine = new HorizontalLayout();
        speedLine.setDefaultComponentAlignment(Alignment.MIDDLE_CENTER);
        speedLine.addComponent((Component)this.speedMinusJB);
        this.speedMinusJB.addMouseDownConsumer(med -> {
            this.curJogState = JogState.SPEED_MINUS;
        });
        this.speedMinusJB.addMouseUpConsumer(med -> this.stopMotion());
        this.speedPlusJB.addMouseDownConsumer(med -> {
            this.curJogState = JogState.SPEED_PLUS;
        });
        this.speedPlusJB.addMouseUpConsumer(med -> this.stopMotion());
        speedLine.addComponent((Component)this.speedPlusJB);
        speedLine.addComponent((Component)this.speedJogLabel);
        jogWorldRightLayout.setSpacing(true);
        jogWorldRightLayout.addComponent((Component)speedLine);
        HorizontalLayout speedButtonLine = new HorizontalLayout();
        speedButtonLine.setSpacing(true);
        this.speed10Button.addClickListener((Button.ClickListener & Serializable)e -> this.sendSetSpeed(0.1));
        speedButtonLine.addComponent((Component)this.speed10Button);
        this.speed50Button.addClickListener((Button.ClickListener & Serializable)e -> this.sendSetSpeed(0.5));
        speedButtonLine.addComponent((Component)this.speed50Button);
        this.speed100Button.addClickListener((Button.ClickListener & Serializable)e -> this.sendSetSpeed(1.0));
        speedButtonLine.addComponent((Component)this.speed100Button);
        jogWorldRightLayout.addComponent((Component)speedButtonLine);
        HorizontalLayout incrementButtonLine = new HorizontalLayout();
        incrementButtonLine.setSpacing(true);
        incrementButtonLine.setDefaultComponentAlignment(Alignment.MIDDLE_CENTER);
        this.jogIncPoint1Button.addClickListener((Button.ClickListener & Serializable)e -> {
            worldAngleIncrementRad = Math.toRadians(0.1);
            jogWorldTransInc = 0.1;
            this.jogIncLabel.setValue(" Increment: " + String.format("%+6.1f ", jogWorldTransInc) + " mm");
        });
        incrementButtonLine.addComponent((Component)this.jogIncPoint1Button);
        this.jogInc1Button.addClickListener((Button.ClickListener & Serializable)e -> {
            worldAngleIncrementRad = Math.toRadians(1.0);
            jogWorldTransInc = 1.0;
            this.jogIncLabel.setValue(" Increment: " + String.format("%+6.1f ", jogWorldTransInc) + " mm");
        });
        incrementButtonLine.addComponent((Component)this.jogInc1Button);
        this.jogInc10Button.addClickListener((Button.ClickListener & Serializable)e -> {
            worldAngleIncrementRad = Math.toRadians(10.0);
            jogWorldTransInc = 10.0;
            this.jogIncLabel.setValue(" Increment: " + String.format("%+6.1f ", jogWorldTransInc) + " mm");
        });
        incrementButtonLine.addComponent((Component)this.jogInc10Button);
        this.jogInc100Button.addClickListener((Button.ClickListener & Serializable)e -> {
            worldAngleIncrementRad = Math.toRadians(100.0);
            jogWorldTransInc = 100.0;
            this.jogIncLabel.setValue(" Increment: " + String.format("%+6.1f ", jogWorldTransInc) + " mm,");
        });
        incrementButtonLine.addComponent((Component)this.jogInc100Button);
        this.jogInc1000Button.addClickListener((Button.ClickListener & Serializable)e -> {
            worldAngleIncrementRad = Math.toRadians(1000.0);
            jogWorldTransInc = 1000.0;
            this.jogIncLabel.setValue(" Increment: " + String.format("%+6.1f ", jogWorldTransInc / 1000.0) + "m");
        });
        incrementButtonLine.addComponent((Component)this.jogInc1000Button);
        jogWorldRightLayout.addComponent((Component)incrementButtonLine);
        HorizontalLayout jogIncLine = new HorizontalLayout();
        jogIncLine.setDefaultComponentAlignment(Alignment.MIDDLE_CENTER);
        jogIncLine.setSpacing(true);
        jogIncLine.addComponent((Component)this.jogIncLabel);
        jogIncLine.addComponent((Component)this.jogIncProgressBar);
        jogWorldRightLayout.addComponent((Component)jogIncLine);
        HorizontalLayout buttonLine = new HorizontalLayout();
        buttonLine.setSpacing(true);
        this.openGripperButton.addClickListener((Button.ClickListener & Serializable)e -> this.openGripper());
        buttonLine.addComponent((Component)this.openGripperButton);
        this.closeGripperButton.addClickListener((Button.ClickListener & Serializable)e -> this.closeGripper());
        buttonLine.addComponent((Component)this.closeGripperButton);
        this.recordPointButton.addClickListener((Button.ClickListener & Serializable)e -> this.recordAndSaveCurrentPoint());
        buttonLine.addComponent((Component)this.recordPointButton);
        jogWorldRightLayout.addComponent((Component)buttonLine);
        jogWorldLayout.addComponent((Component)jogWorldRightLayout);
        for (int i = 0; i < this.jogJointLines.length; ++i) {
            HorizontalLayout hl;
            int jointIndex = i;
            this.jogJointLines[i] = hl = new HorizontalLayout();
            hl.setDefaultComponentAlignment(Alignment.MIDDLE_CENTER);
            JogButton jmButton = this.jogJointMinusButtons[i];
            jmButton.addMouseDownConsumer(med -> {
                this.curJogState = JogState.JOINT_MINUS;
                this.jogJointNumber = jointIndex;
            });
            jmButton.addMouseUpConsumer(med -> this.stopMotion());
            hl.addComponent((Component)jmButton);
            JogButton jpButton = this.jogJointPlusButtons[i];
            jpButton.addMouseDownConsumer(med -> {
                this.curJogState = JogState.JOINT_PLUS;
                this.jogJointNumber = jointIndex;
            });
            jpButton.addMouseUpConsumer(med -> this.stopMotion());
            hl.addComponent((Component)jpButton);
            hl.addComponent((Component)this.jogJointLabels[i]);
            jogJointLeftLayout.addComponent((Component)this.jogJointLines[i]);
        }
        jogJointLayout.addComponent((Component)jogJointLeftLayout);
        HorizontalLayout jointSpeedLine = new HorizontalLayout();
        jointSpeedLine.setDefaultComponentAlignment(Alignment.MIDDLE_CENTER);
        jointSpeedLine.addComponent((Component)this.jointSpeedMinusJB);
        this.jointSpeedMinusJB.addMouseDownConsumer(med -> {
            this.curJogState = JogState.SPEED_MINUS;
        });
        this.jointSpeedMinusJB.addMouseUpConsumer(med -> this.stopMotion());
        this.jointSpeedPlusJB.addMouseDownConsumer(med -> {
            this.curJogState = JogState.SPEED_PLUS;
        });
        this.jointSpeedPlusJB.addMouseUpConsumer(med -> this.stopMotion());
        jointSpeedLine.addComponent((Component)this.jointSpeedPlusJB);
        jointSpeedLine.addComponent((Component)this.jointSpeedJogLabel);
        jogJointRightLayout.setSpacing(true);
        jogJointRightLayout.addComponent((Component)jointSpeedLine);
        HorizontalLayout jointSpeedButtonLine = new HorizontalLayout();
        jointSpeedButtonLine.setSpacing(true);
        this.jointSpeed10Button.addClickListener((Button.ClickListener & Serializable)e -> this.sendSetSpeed(0.1));
        jointSpeedButtonLine.addComponent((Component)this.jointSpeed10Button);
        this.jointSpeed50Button.addClickListener((Button.ClickListener & Serializable)e -> this.sendSetSpeed(0.5));
        jointSpeedButtonLine.addComponent((Component)this.jointSpeed50Button);
        this.jointSpeed100Button.addClickListener((Button.ClickListener & Serializable)e -> this.sendSetSpeed(1.0));
        jointSpeedButtonLine.addComponent((Component)this.jointSpeed100Button);
        jogJointRightLayout.addComponent((Component)jointSpeedButtonLine);
        HorizontalLayout jointIncrementButtonLine = new HorizontalLayout();
        jointIncrementButtonLine.setSpacing(true);
        jointIncrementButtonLine.setDefaultComponentAlignment(Alignment.MIDDLE_CENTER);
        this.jointJogIncPoint1Button.addClickListener((Button.ClickListener & Serializable)e -> {
            this.jointJogIncrement = 0.1;
            this.jointJogIncLabel.setValue(" Increment: " + String.format("%+6.1f ", this.jointJogIncrement) + " deg");
        });
        jointIncrementButtonLine.addComponent((Component)this.jointJogIncPoint1Button);
        this.jointJogInc1Button.addClickListener((Button.ClickListener & Serializable)e -> {
            this.jointJogIncrement = 1.0;
            this.jointJogIncLabel.setValue(" Increment: " + String.format("%+6.1f ", this.jointJogIncrement) + " deg");
        });
        jointIncrementButtonLine.addComponent((Component)this.jointJogInc1Button);
        this.jointJogInc10Button.addClickListener((Button.ClickListener & Serializable)e -> {
            this.jointJogIncrement = 10.0;
            this.jointJogIncLabel.setValue(" Increment: " + String.format("%+6.1f ", this.jointJogIncrement) + " deg");
        });
        jointIncrementButtonLine.addComponent((Component)this.jointJogInc10Button);
        this.jointJogInc100Button.addClickListener((Button.ClickListener & Serializable)e -> {
            this.jointJogIncrement = 100.0;
            this.jointJogIncLabel.setValue(" Increment: " + String.format("%+6.1f ", this.jointJogIncrement) + " deg");
        });
        jointIncrementButtonLine.addComponent((Component)this.jointJogInc100Button);
        jogJointRightLayout.addComponent((Component)jointIncrementButtonLine);
        HorizontalLayout jointJogIncLine = new HorizontalLayout();
        jointJogIncLine.setDefaultComponentAlignment(Alignment.MIDDLE_CENTER);
        jointJogIncLine.setSpacing(true);
        jointJogIncLine.addComponent((Component)this.jointJogIncLabel);
        jointJogIncLine.addComponent((Component)this.jointJogIncProgressBar);
        jogJointRightLayout.addComponent((Component)jointJogIncLine);
        jogJointLayout.addComponent((Component)jogJointRightLayout);
        navLayout.addComponent((Component)this.statusLabel);
        this.connect();
    }

    public void setupRotTable(Table rotTable) throws UnsupportedOperationException {
        rotTable.addContainerProperty((Object)"Axis", String.class, null);
        rotTable.addContainerProperty((Object)"I", Double.class, null);
        rotTable.addContainerProperty((Object)"J", Double.class, null);
        rotTable.addContainerProperty((Object)"K", Double.class, null);
        rotTable.addItem(new Object[]{"X", 1.0, 0.0, 0.0}, (Object)"X");
        rotTable.addItem(new Object[]{"Z", 0.0, 0.0, 1.0}, (Object)"Z");
        rotTable.setWidth("220px");
        rotTable.setHeight("120px");
    }

    private void updateStatusLabel() {
        CommandStatusType cmdStat;
        StringBuffer sb = new StringBuffer("Status: ");
        sb.append("connected=");
        sb.append(this.socket != null && this.socket.isConnected());
        sb.append(", ");
        sb.append("program_running=");
        sb.append(this.running);
        sb.append(", ");
        sb.append("program_index=");
        sb.append(commonInfo.getProgramIndex());
        sb.append(", ");
        sb.append("programFile=");
        sb.append(commonInfo.getCurrentFileName());
        sb.append(", ");
        sb.append("lastCmdIdSent=");
        sb.append(this.lastCmdIdSent);
        sb.append(", ");
        if (this.stat != null && null != (cmdStat = this.stat.getCommandStatus())) {
            sb.append("statusId=");
            sb.append(cmdStat.getStatusID());
            sb.append(", ");
            sb.append("commandID=");
            sb.append(cmdStat.getCommandID());
            sb.append(", ");
            sb.append("state=");
            sb.append(cmdStat.getCommandState());
            sb.append(", ");
            sb.append("description=");
            sb.append(cmdStat.getStateDescription());
            sb.append(", ");
        }
        this.statusLabel.setValue(sb.toString());
    }

    public void disconnect() {
        try {
            ++this.disconnectCount;
            if (null != this.updateThread) {
                this.updateThread.interrupt();
                try {
                    this.updateThread.join(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.updateThread = null;
            }
            if (null != this.monitorThread) {
                this.monitorThread.interrupt();
                try {
                    this.monitorThread.join(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.monitorThread = null;
            }
            if (null != this.socket) {
                this.socket.close();
                this.socket = null;
            }
            this.stat = null;
            this.running = false;
            this.mySyncAccess(() -> {
                this.connectButton.setEnabled(true);
                this.disconnectButton.setEnabled(false);
                this.updateStateLabels(CommandStateEnumType.CRCL_ERROR);
                this.stateDescriptionLbl.setValue("DISCONNECTED from CRCL Server");
            });
            this.updateStatusLabel();
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    public void setupPosTable(Table tbl) throws UnsupportedOperationException {
        tbl.addContainerProperty((Object)"Axis", String.class, null);
        tbl.addContainerProperty((Object)"Value", Double.class, null);
        tbl.addItem(new Object[]{"X", 0.0}, (Object)0);
        tbl.addItem(new Object[]{"Y", 0.0}, (Object)1);
        tbl.addItem(new Object[]{"Z", 0.0}, (Object)2);
        tbl.setWidth("220px");
        tbl.setHeight("160px");
    }

    public void setupTransformTable(Table tbl) throws UnsupportedOperationException {
        tbl.addContainerProperty((Object)"Axis", String.class, null);
        tbl.addContainerProperty((Object)"Value", Double.class, null);
        tbl.addItem(new Object[]{"X", 0.0}, (Object)0);
        tbl.addItem(new Object[]{"Y", 0.0}, (Object)1);
        tbl.addItem(new Object[]{"Z", 0.0}, (Object)2);
        tbl.addItem(new Object[]{"X I", 1.0}, (Object)3);
        tbl.addItem(new Object[]{"X J", 0.0}, (Object)4);
        tbl.addItem(new Object[]{"X K", 0.0}, (Object)5);
        tbl.addItem(new Object[]{"Z I", 0.0}, (Object)6);
        tbl.addItem(new Object[]{"Z J", 0.0}, (Object)7);
        tbl.addItem(new Object[]{"Z K", 1.0}, (Object)8);
        tbl.setWidth("300px");
        tbl.setHeight("450px");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMotion() {
        try {
            this.curJogState = JogState.NONE;
            StopMotionType stopMotionCmd = new StopMotionType();
            stopMotionCmd.setStopCondition(StopConditionEnumType.IMMEDIATE);
            long nextId = this.lastCmdIdSent + 1L;
            stopMotionCmd.setCommandID(nextId);
            this.sendCommand((CRCLCommandType)stopMotionCmd);
            this.cmdQueue.clear();
        }
        catch (CRCLException ex) {
            Logger.getLogger(CrclClientUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            this.curJogState = JogState.NONE;
        }
    }

    public void sendCommand(CRCLCommandType cmd) throws CRCLException {
        if (cmd.getCommandID() < 1L) {
            long nextId = this.lastCmdIdSent + 1L;
            cmd.setCommandID(nextId);
        }
        if (null != this.instance && null != this.socket) {
            this.instance.setCRCLCommand(cmd);
            if (this.running) {
                this.instance.setProgramFile(commonInfo.getCurrentFileName());
                this.instance.setProgramIndex(Integer.valueOf(commonInfo.getProgramIndex()));
                this.instance.setProgramLength(Integer.valueOf(commonInfo.getCurrentProgram().getMiddleCommand().size()));
            } else {
                this.instance.setProgramFile(null);
                this.instance.setProgramIndex(null);
                this.instance.setProgramLength(null);
            }
            this.socket.writeCommand(this.instance);
            this.lastCmdIdSent = this.instance.getCRCLCommand().getCommandID();
        }
    }

    public void close() {
        try {
            this.running = false;
            this.prevCommonInfo = CommonInfo.defaultWithRemotePrograms((String[])new String[0]);
            this.disconnect();
        }
        finally {
            super.close();
        }
    }

    public void sendSetSpeed(double fraction) {
        try {
            speedFraction = fraction;
            SetTransSpeedType setSpeedCmd = new SetTransSpeedType();
            TransSpeedRelativeType relSpeed = new TransSpeedRelativeType();
            relSpeed.setFraction(speedFraction);
            setSpeedCmd.setTransSpeed((TransSpeedType)relSpeed);
            this.sendCommand((CRCLCommandType)setSpeedCmd);
            this.mySyncAccess(() -> {
                this.speedJogLabel.setValue(" Speed: " + String.format("%+6.1f ", speedFraction * 100.0) + " % ");
                this.jointSpeedJogLabel.setValue(" Speed: " + String.format("%+6.1f ", speedFraction * 100.0) + " % ");
            });
        }
        catch (CRCLException ex) {
            Logger.getLogger(CrclClientUI.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void connect() {
        try {
            this.connectCount = this.disconnectCount;
            if (null != this.socket) {
                this.socket.close();
            }
            if (null != this.updateThread) {
                this.updateThread.interrupt();
                try {
                    this.updateThread.join();
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
            }
            this.socket = new CRCLSocket((String)this.hostField.getValue(), Integer.parseInt((String)this.portField.getValue()));
            this.mySyncAccess(() -> {
                this.connectButton.setEnabled(false);
                this.disconnectButton.setEnabled(true);
            });
            this.cmdQueue.clear();
            this.running = false;
            this.updateThread = new Thread(() -> this.pollForStatus(), "pollForStatus" + this.getSession());
            this.updateThread.start();
            this.monitorThread = new Thread(() -> this.monitorConnection(), "monitorConnection" + this.getSession());
            this.monitorThread.start();
            this.accept(commonInfo);
            this.updateStatusLabel();
        }
        catch (CRCLException | IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
            this.updateStateLabels(CommandStateEnumType.CRCL_ERROR);
            this.stateDescriptionLbl.setValue("Connect failed : " + ex);
        }
    }

    public void sendInit() throws CRCLException {
        InitCanonType initCmd = new InitCanonType();
        long nextId = this.lastCmdIdSent + 1L;
        initCmd.setCommandID(nextId);
        this.sendCommand((CRCLCommandType)initCmd);
    }

    private void monitorConnection() {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                Thread.sleep(300L);
                long diff = System.currentTimeMillis() - this.lastUpdateTime;
                if (diff <= 500L) continue;
                this.access(() -> {
                    this.updateStateLabels(CommandStateEnumType.CRCL_ERROR);
                    this.stateDescriptionLbl.setValue("TIMEOUT Communicating with CRCL Server : " + diff + " ms");
                });
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger(CrclClientUI.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void pollForStatus() {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                CommandStatusType cst;
                MiddleCommandType cmd;
                Thread.sleep(200L);
                CRCLCommandInstanceType instance = new CRCLCommandInstanceType();
                GetStatusType getStatus = new GetStatusType();
                getStatus.setCommandID(1L);
                instance.setCRCLCommand((CRCLCommandType)getStatus);
                this.socket.writeCommand(instance);
                this.stat = this.socket.readStatus();
                if (null == this.stat || null == this.stat.getCommandStatus() || this.stat.getCommandStatus().getCommandState() == CommandStateEnumType.CRCL_ERROR) {
                    this.running = false;
                    this.cmdQueue.clear();
                    System.err.println("stat=" + this.stat);
                }
                if (null == this.stat) continue;
                this.lastUpdateTime = System.currentTimeMillis();
                this.updateStatusLabel();
                int program_index = commonInfo.getProgramIndex();
                CRCLProgramType program = commonInfo.getCurrentProgram();
                if (this.running && null != program && null != this.stat && null != this.stat.getCommandStatus() && program_index < program.getMiddleCommand().size() && (this.skip_wait_for_done || this.stat.getCommandStatus().getCommandState() == CommandStateEnumType.CRCL_DONE && (program_index < 1 || (long)(program_index + 1) <= this.stat.getCommandStatus().getCommandID()))) {
                    this.runOneProgramStep(program_index + 1);
                    this.cmdQueue.clear();
                }
                if (this.stat.getCommandStatus().getCommandID() >= this.lastCmdIdSent && this.stat.getCommandStatus().getCommandState() == CommandStateEnumType.CRCL_DONE && null != (cmd = (MiddleCommandType)this.cmdQueue.poll())) {
                    long id = this.lastCmdIdSent + 1L;
                    cmd.setCommandID(id);
                    instance.setCRCLCommand((CRCLCommandType)cmd);
                    this.socket.writeCommand(instance);
                    this.lastCmdIdSent = id;
                }
                if (null != (cst = this.stat.getCommandStatus()) && !this.running) {
                    int index;
                    if (null != cst.getProgramFile() && !cst.getProgramFile().isEmpty() && !cst.getProgramFile().equals(commonInfo.getCurrentFileName()) && !cst.getProgramFile().equals(this.lastProgramFile) && Stream.of(commonInfo.getRemotePrograms()).anyMatch(x -> x.equals(cst.getProgramFile()))) {
                        this.selectedRemoteProgramFilename = cst.getProgramFile();
                        this.loadSelectedRemoteProgram();
                        this.lastProgramFile = cst.getProgramFile();
                    }
                    if (null != cst.getProgramIndex() && (index = cst.getProgramIndex().intValue()) != this.lastProgramIndex && index != commonInfo.getProgramIndex()) {
                        CrclClientUI.setCommonInfo((CommonInfo)CommonInfo.withProgramIndex((CommonInfo)commonInfo, (int)index));
                    }
                }
                this.access(() -> this.updateUIComponents(this.stat));
            }
        }
        catch (CRCLException ex) {
            this.running = false;
            if (this.disconnectCount <= this.connectCount) {
                Logger.getLogger(CrclClientUI.class.getName()).log(Level.SEVERE, null, ex);
                this.updateStateLabels(CommandStateEnumType.CRCL_ERROR);
                this.stateDescriptionLbl.setValue(ex.toString());
                System.err.println("connectCount = " + this.connectCount);
                System.err.println("disconnectCount = " + this.disconnectCount);
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger(CrclClientUI.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void refresh(VaadinRequest request) {
        if (this.getPushConnection() != null && this.getPushConnection().isConnected()) {
            this.getPushConnection().disconnect();
        }
        super.refresh(request);
    }

    private void loadPointToTable(PointType pt, Table tbl) {
        Property ip;
        if (null == pt) {
            return;
        }
        Item it = tbl.getItem((Object)0);
        if (null != it && null != (ip = it.getItemProperty((Object)"Value"))) {
            ip.setValue((Object)pt.getX());
        }
        if (null != (it = tbl.getItem((Object)1)) && null != (ip = it.getItemProperty((Object)"Value"))) {
            ip.setValue((Object)pt.getY());
        }
        if (null != (it = tbl.getItem((Object)2)) && null != (ip = it.getItemProperty((Object)"Value"))) {
            ip.setValue((Object)pt.getZ());
        }
    }

    private PoseType getPoseFromTable(Table tbl) {
        PoseType pose = new PoseType();
        PmCartesian cart = this.getPmPointFromTable(tbl);
        VectorType xAxis = new VectorType();
        xAxis.setI(Double.valueOf(tbl.getItem((Object)3).getItemProperty((Object)"Value").getValue().toString()).doubleValue());
        xAxis.setJ(Double.valueOf(tbl.getItem((Object)4).getItemProperty((Object)"Value").getValue().toString()).doubleValue());
        xAxis.setK(Double.valueOf(tbl.getItem((Object)5).getItemProperty((Object)"Value").getValue().toString()).doubleValue());
        VectorType zAxis = new VectorType();
        zAxis.setI(Double.valueOf(tbl.getItem((Object)6).getItemProperty((Object)"Value").getValue().toString()).doubleValue());
        zAxis.setJ(Double.valueOf(tbl.getItem((Object)7).getItemProperty((Object)"Value").getValue().toString()).doubleValue());
        zAxis.setK(Double.valueOf(tbl.getItem((Object)8).getItemProperty((Object)"Value").getValue().toString()).doubleValue());
        pose.setPoint(CRCLPosemath.toPointType((PmCartesian)cart));
        pose.setXAxis(xAxis);
        pose.setZAxis(zAxis);
        return pose;
    }

    private void loadPoseToTable(PoseType pose, Table tbl) {
        VectorType zAxis;
        if (null == pose) {
            return;
        }
        PointType pt = pose.getPoint();
        this.loadPointToTable(pt, tbl);
        VectorType xAxis = pose.getXAxis();
        if (null != xAxis) {
            Property ip;
            Item it = tbl.getItem((Object)3);
            if (null != it && null != (ip = it.getItemProperty((Object)"Value"))) {
                ip.setValue((Object)xAxis.getI());
            }
            if (null != (it = tbl.getItem((Object)4)) && null != (ip = it.getItemProperty((Object)"Value"))) {
                ip.setValue((Object)xAxis.getJ());
            }
            if (null != (it = tbl.getItem((Object)5)) && null != (ip = it.getItemProperty((Object)"Value"))) {
                ip.setValue((Object)xAxis.getK());
            }
        }
        if (null != (zAxis = pose.getZAxis())) {
            Property ip;
            Item it = tbl.getItem((Object)6);
            if (null != it && null != (ip = it.getItemProperty((Object)"Value"))) {
                ip.setValue((Object)zAxis.getI());
            }
            if (null != (it = tbl.getItem((Object)7)) && null != (ip = it.getItemProperty((Object)"Value"))) {
                ip.setValue((Object)zAxis.getJ());
            }
            if (null != (it = tbl.getItem((Object)8)) && null != (ip = it.getItemProperty((Object)"Value"))) {
                ip.setValue((Object)zAxis.getK());
            }
        }
    }

    private static float computeFraction(double goal, double current, double inc) {
        return (float)(Math.abs(inc - Math.abs(goal - current)) / inc);
    }

    private void updateUIComponents(CRCLStatusType stat) {
        try {
            block46: {
                PoseType pose;
                block47: {
                    Property ip;
                    PointType pt;
                    block49: {
                        block48: {
                            CommandStatusType cst = stat.getCommandStatus();
                            if (null != cst) {
                                this.cmdIdLbl.setValue("Command ID: " + String.format("%10s", cst.getCommandID()));
                                this.updateStateLabels(cst.getCommandState());
                                String description = cst.getStateDescription();
                                if (null == description) {
                                    description = "";
                                }
                                if (cst.getCommandState() == CommandStateEnumType.CRCL_ERROR && description.length() > 1 && !description.equals(this.lastDescription)) {
                                    new Notification(description).show(Page.getCurrent());
                                    this.lastDescription = description;
                                }
                                if (description.length() > 40) {
                                    description = description.substring(0, 36) + " ...";
                                }
                                this.stateDescriptionLbl.setValue(description);
                                this.statusIdLbl.setValue("Status ID: " + cst.getStatusID());
                            }
                            if (stat.getGripperStatus() == null || stat.getGripperStatus().isHoldingObject() == null) {
                                this.holdingObjectLbl.setValue("HoldingObject : UKNOWN");
                                this.holdingObjectLbl.removeStyleName("NOT_HOLDING_OBJECT");
                                this.holdingObjectLbl.removeStyleName("HOLDING_OBJECT");
                            } else if (stat.getGripperStatus().isHoldingObject().booleanValue()) {
                                this.holdingObjectLbl.setValue("HoldingObject : TRUE");
                                this.holdingObjectLbl.addStyleName("HOLDING_OBJECT");
                                this.holdingObjectLbl.removeStyleName("NOT_HOLDING_OBJECT");
                            } else {
                                this.holdingObjectLbl.setValue("HoldingObject : FALSE");
                                this.holdingObjectLbl.removeStyleName("HOLDING_OBJECT");
                                this.holdingObjectLbl.addStyleName("NOT_HOLDING_OBJECT");
                            }
                            pose = CRCLPosemath.getPose((CRCLStatusType)stat);
                            if (null == pose) break block46;
                            globalCurrentPose = this.currentPose = pose;
                            CrclClientUI.updateImages((CommonInfo)commonInfo, (CommonInfo)commonInfo);
                            pt = pose.getPoint();
                            if (null == pt) break block47;
                            this.currentPoint = pt;
                            if (cst.getCommandState() != CommandStateEnumType.CRCL_DONE || cst.getCommandID() < this.lastCmdIdSent) break block48;
                            this.prevJogState = JogState.NONE;
                            MoveToType moveToCmd = new MoveToType();
                            ActuateJointsType actuateJointsCmd = new ActuateJointsType();
                            PoseType endPos = new PoseType();
                            endPos.setPoint(new PointType());
                            endPos.setXAxis(new VectorType());
                            endPos.setZAxis(new VectorType());
                            moveToCmd.setEndPosition(endPos);
                            moveToCmd.getEndPosition().getPoint().setX(pose.getPoint().getX());
                            moveToCmd.getEndPosition().getPoint().setY(pose.getPoint().getY());
                            moveToCmd.getEndPosition().getPoint().setZ(pose.getPoint().getZ());
                            moveToCmd.getEndPosition().getXAxis().setI(pose.getXAxis().getI());
                            moveToCmd.getEndPosition().getXAxis().setJ(pose.getXAxis().getJ());
                            moveToCmd.getEndPosition().getXAxis().setK(pose.getXAxis().getK());
                            moveToCmd.getEndPosition().getZAxis().setI(pose.getZAxis().getI());
                            moveToCmd.getEndPosition().getZAxis().setJ(pose.getZAxis().getJ());
                            moveToCmd.getEndPosition().getZAxis().setK(pose.getZAxis().getK());
                            switch (14.$SwitchMap$crcl$vaadin$ui$CrclClientUI$JogState[this.curJogState.ordinal()]) {
                                case 1: {
                                    moveToCmd.getEndPosition().getPoint().setX(pose.getPoint().getX() - jogWorldTransInc);
                                    long nextId = this.lastCmdIdSent + 1L;
                                    moveToCmd.setCommandID(nextId);
                                    this.sendCommand((CRCLCommandType)moveToCmd);
                                    break;
                                }
                                case 2: {
                                    moveToCmd.getEndPosition().getPoint().setX(pose.getPoint().getX() + jogWorldTransInc);
                                    long nextId = this.lastCmdIdSent + 1L;
                                    moveToCmd.setCommandID(nextId);
                                    this.sendCommand((CRCLCommandType)moveToCmd);
                                    break;
                                }
                                case 3: {
                                    moveToCmd.getEndPosition().getPoint().setY(pose.getPoint().getY() - jogWorldTransInc);
                                    long nextId = this.lastCmdIdSent + 1L;
                                    moveToCmd.setCommandID(nextId);
                                    this.sendCommand((CRCLCommandType)moveToCmd);
                                    break;
                                }
                                case 4: {
                                    moveToCmd.getEndPosition().getPoint().setY(pose.getPoint().getY() + jogWorldTransInc);
                                    long nextId = this.lastCmdIdSent + 1L;
                                    moveToCmd.setCommandID(nextId);
                                    this.sendCommand((CRCLCommandType)moveToCmd);
                                    break;
                                }
                                case 5: {
                                    moveToCmd.getEndPosition().getPoint().setZ(pose.getPoint().getZ() - jogWorldTransInc);
                                    long nextId = this.lastCmdIdSent + 1L;
                                    moveToCmd.setCommandID(nextId);
                                    this.sendCommand((CRCLCommandType)moveToCmd);
                                    break;
                                }
                                case 6: {
                                    moveToCmd.getEndPosition().getPoint().setZ(pose.getPoint().getZ() + jogWorldTransInc);
                                    long nextId = this.lastCmdIdSent + 1L;
                                    moveToCmd.setCommandID(nextId);
                                    this.sendCommand((CRCLCommandType)moveToCmd);
                                    break;
                                }
                                case 7: {
                                    Object rpy = CRCLPosemath.toPmRpy((PoseType)pose);
                                    ((PmRpy)rpy).r -= worldAngleIncrementRad;
                                    moveToCmd.setEndPosition(CRCLPosemath.toPoseType((PmCartesian)CRCLPosemath.toPmCartesian((PointType)pt), (PmRpy)rpy));
                                    long nextId = this.lastCmdIdSent + 1L;
                                    moveToCmd.setCommandID(nextId);
                                    this.sendCommand((CRCLCommandType)moveToCmd);
                                    break;
                                }
                                case 8: {
                                    Object rpy = CRCLPosemath.toPmRpy((PoseType)pose);
                                    ((PmRpy)rpy).r += worldAngleIncrementRad;
                                    moveToCmd.setEndPosition(CRCLPosemath.toPoseType((PmCartesian)CRCLPosemath.toPmCartesian((PointType)pt), (PmRpy)rpy));
                                    long nextId = this.lastCmdIdSent + 1L;
                                    moveToCmd.setCommandID(nextId);
                                    this.sendCommand((CRCLCommandType)moveToCmd);
                                    break;
                                }
                                case 9: {
                                    Object rpy = CRCLPosemath.toPmRpy((PoseType)pose);
                                    ((PmRpy)rpy).p -= worldAngleIncrementRad;
                                    moveToCmd.setEndPosition(CRCLPosemath.toPoseType((PmCartesian)CRCLPosemath.toPmCartesian((PointType)pt), (PmRpy)rpy));
                                    long nextId = this.lastCmdIdSent + 1L;
                                    moveToCmd.setCommandID(nextId);
                                    this.sendCommand((CRCLCommandType)moveToCmd);
                                    break;
                                }
                                case 10: {
                                    Object rpy = CRCLPosemath.toPmRpy((PoseType)pose);
                                    ((PmRpy)rpy).p += worldAngleIncrementRad;
                                    moveToCmd.setEndPosition(CRCLPosemath.toPoseType((PmCartesian)CRCLPosemath.toPmCartesian((PointType)pt), (PmRpy)rpy));
                                    long nextId = this.lastCmdIdSent + 1L;
                                    moveToCmd.setCommandID(nextId);
                                    this.sendCommand((CRCLCommandType)moveToCmd);
                                    break;
                                }
                                case 11: {
                                    Object rpy = CRCLPosemath.toPmRpy((PoseType)pose);
                                    ((PmRpy)rpy).y -= worldAngleIncrementRad;
                                    moveToCmd.setEndPosition(CRCLPosemath.toPoseType((PmCartesian)CRCLPosemath.toPmCartesian((PointType)pt), (PmRpy)rpy));
                                    long nextId = this.lastCmdIdSent + 1L;
                                    moveToCmd.setCommandID(nextId);
                                    this.sendCommand((CRCLCommandType)moveToCmd);
                                    break;
                                }
                                case 12: {
                                    Object rpy = CRCLPosemath.toPmRpy((PoseType)pose);
                                    ((PmRpy)rpy).y += worldAngleIncrementRad;
                                    moveToCmd.setEndPosition(CRCLPosemath.toPoseType((PmCartesian)CRCLPosemath.toPmCartesian((PointType)pt), (PmRpy)rpy));
                                    long nextId = this.lastCmdIdSent + 1L;
                                    moveToCmd.setCommandID(nextId);
                                    this.sendCommand((CRCLCommandType)moveToCmd);
                                    break;
                                }
                                case 13: {
                                    JointSpeedAccelType jas;
                                    ActuateJointType actuateJoint;
                                    for (JointStatusType js : stat.getJointStatuses().getJointStatus()) {
                                        actuateJoint = new ActuateJointType();
                                        actuateJoint.setJointNumber(js.getJointNumber());
                                        actuateJoint.setJointPosition(js.getJointPosition().doubleValue());
                                        if (this.jogJointNumber == js.getJointNumber() - 1) {
                                            actuateJoint.setJointPosition(js.getJointPosition() - this.jointJogIncrement);
                                        }
                                        jas = new JointSpeedAccelType();
                                        jas.setJointSpeed(Double.valueOf(this.jointJogSpeed));
                                        actuateJoint.setJointDetails((JointDetailsType)jas);
                                        actuateJointsCmd.getActuateJoint().add(actuateJoint);
                                    }
                                    long nextId = this.lastCmdIdSent + 1L;
                                    actuateJointsCmd.setCommandID(nextId);
                                    this.sendCommand((CRCLCommandType)actuateJointsCmd);
                                    break;
                                }
                                case 14: {
                                    JointSpeedAccelType jas;
                                    ActuateJointType actuateJoint;
                                    for (JointStatusType js : stat.getJointStatuses().getJointStatus()) {
                                        actuateJoint = new ActuateJointType();
                                        actuateJoint.setJointNumber(js.getJointNumber());
                                        actuateJoint.setJointPosition(js.getJointPosition().doubleValue());
                                        if (this.jogJointNumber == js.getJointNumber() - 1) {
                                            actuateJoint.setJointPosition(js.getJointPosition() + this.jointJogIncrement);
                                        }
                                        jas = new JointSpeedAccelType();
                                        jas.setJointSpeed(Double.valueOf(this.jointJogSpeed));
                                        actuateJoint.setJointDetails((JointDetailsType)jas);
                                        actuateJointsCmd.getActuateJoint().add(actuateJoint);
                                    }
                                    long nextId = this.lastCmdIdSent + 1L;
                                    actuateJointsCmd.setCommandID(nextId);
                                    this.sendCommand((CRCLCommandType)actuateJointsCmd);
                                    break;
                                }
                                case 15: {
                                    if (!(speedFraction > 0.01)) break;
                                    SetTransSpeedType setSpeedCmd = new SetTransSpeedType();
                                    TransSpeedRelativeType relSpeed = new TransSpeedRelativeType();
                                    relSpeed.setFraction(speedFraction -= 0.01);
                                    setSpeedCmd.setTransSpeed((TransSpeedType)relSpeed);
                                    long nextId = this.lastCmdIdSent + 1L;
                                    setSpeedCmd.setCommandID(nextId);
                                    this.sendCommand((CRCLCommandType)setSpeedCmd);
                                    this.speedJogLabel.setValue(" Speed: " + String.format("%+6.1f ", speedFraction * 100.0) + " % ");
                                    this.jointSpeedJogLabel.setValue(" Speed: " + String.format("%+6.1f ", speedFraction * 100.0) + " % ");
                                    break;
                                }
                                case 16: {
                                    if (!(speedFraction < 0.99)) break;
                                    SetTransSpeedType setSpeedCmd = new SetTransSpeedType();
                                    TransSpeedRelativeType relSpeed = new TransSpeedRelativeType();
                                    relSpeed.setFraction(speedFraction += 0.01);
                                    setSpeedCmd.setTransSpeed((TransSpeedType)relSpeed);
                                    long nextId = this.lastCmdIdSent + 1L;
                                    setSpeedCmd.setCommandID(nextId);
                                    this.sendCommand((CRCLCommandType)setSpeedCmd);
                                    this.speedJogLabel.setValue(" Speed: " + String.format("%+6.1f ", speedFraction * 100.0) + " % ");
                                    this.jointSpeedJogLabel.setValue(" Speed: " + String.format("%+6.1f ", speedFraction * 100.0) + " % ");
                                    break;
                                }
                            }
                            if (this.curJogState == JogState.NONE || this.curJogState == JogState.SPEED_MINUS || this.curJogState == JogState.SPEED_PLUS) break block49;
                            this.prevMoveTo = moveToCmd;
                            this.prevActuateJoints = actuateJointsCmd;
                            this.prevJogState = this.curJogState;
                            this.curJogState = JogState.NONE;
                            this.jogIncProgressBar.setValue(Float.valueOf(0.0f));
                            this.jointJogIncProgressBar.setValue(Float.valueOf(0.0f));
                            break block49;
                        }
                        switch (14.$SwitchMap$crcl$vaadin$ui$CrclClientUI$JogState[this.prevJogState.ordinal()]) {
                            case 1: 
                            case 2: {
                                if (null == this.prevMoveTo) break;
                                float fraction = CrclClientUI.computeFraction((double)this.prevMoveTo.getEndPosition().getPoint().getX(), (double)pt.getX(), (double)jogWorldTransInc);
                                this.jogIncProgressBar.setValue(Float.valueOf(fraction));
                                break;
                            }
                            case 3: 
                            case 4: {
                                if (null == this.prevMoveTo) break;
                                float fraction = CrclClientUI.computeFraction((double)this.prevMoveTo.getEndPosition().getPoint().getY(), (double)pt.getY(), (double)jogWorldTransInc);
                                this.jogIncProgressBar.setValue(Float.valueOf(fraction));
                                break;
                            }
                            case 5: 
                            case 6: {
                                if (null == this.prevMoveTo) break;
                                float fraction = CrclClientUI.computeFraction((double)this.prevMoveTo.getEndPosition().getPoint().getZ(), (double)pt.getZ(), (double)jogWorldTransInc);
                                this.jogIncProgressBar.setValue(Float.valueOf(fraction));
                                break;
                            }
                            case 13: 
                            case 14: {
                                int i;
                                if (null == this.prevActuateJoints) break;
                                double curPosition = Double.NaN;
                                double goalPosition = Double.NaN;
                                boolean curPositionSet = false;
                                boolean goalPositionSet = false;
                                long jointNumber = this.jogJointNumber + 1;
                                for (i = 0; i < stat.getJointStatuses().getJointStatus().size(); ++i) {
                                    JointStatusType js = (JointStatusType)stat.getJointStatuses().getJointStatus().get(i);
                                    if ((long)js.getJointNumber() != jointNumber) continue;
                                    curPosition = js.getJointPosition();
                                    curPositionSet = true;
                                    break;
                                }
                                for (i = 0; i < this.prevActuateJoints.getActuateJoint().size(); ++i) {
                                    ActuateJointType aj = (ActuateJointType)this.prevActuateJoints.getActuateJoint().get(i);
                                    if ((long)aj.getJointNumber() != jointNumber) continue;
                                    goalPosition = aj.getJointPosition();
                                    goalPositionSet = true;
                                    break;
                                }
                                if (!curPositionSet || !goalPositionSet || !Double.isFinite(curPosition) || !Double.isFinite(goalPosition)) break;
                                float fraction = CrclClientUI.computeFraction((double)goalPosition, (double)curPosition, (double)this.jointJogIncrement);
                                this.jointJogIncProgressBar.setValue(Float.valueOf(fraction));
                                break;
                            }
                            default: {
                                assert (false) : "prevJogState=" + this.prevJogState;
                                break;
                            }
                        }
                    }
                    Item it = this.posCurrentTable.getItem((Object)0);
                    if (null != it && null != (ip = it.getItemProperty((Object)"Value"))) {
                        ip.setValue((Object)pt.getX());
                    }
                    this.xJogLabel.setValue(" X: " + String.format("%+6.1f ", pt.getX()) + " mm ");
                    it = this.posCurrentTable.getItem((Object)1);
                    if (null != it && null != (ip = it.getItemProperty((Object)"Value"))) {
                        ip.setValue((Object)pt.getY());
                    }
                    this.yJogLabel.setValue(" Y: " + String.format("%+6.1f ", pt.getY()) + " mm ");
                    it = this.posCurrentTable.getItem((Object)2);
                    if (null != it && null != (ip = it.getItemProperty((Object)"Value"))) {
                        ip.setValue((Object)pt.getZ());
                    }
                    this.zJogLabel.setValue(" Z: " + String.format("%+6.1f ", pt.getZ()) + " mm ");
                    PmRpy rpy = CRCLPosemath.toPmRpy((PoseType)pose);
                    this.rollJogLabel.setValue(" Roll: " + String.format("%+6.1f ", Math.toDegrees(rpy.r)) + " degrees ");
                    this.pitchJogLabel.setValue(" Pitch: " + String.format("%+6.1f ", Math.toDegrees(rpy.p)) + " degrees  ");
                    this.yawJogLabel.setValue(" Yaw: " + String.format("%+6.1f ", Math.toDegrees(rpy.y)) + " degrees  ");
                    JointStatusesType jointStatuses = stat.getJointStatuses();
                    if (null != jointStatuses) {
                        for (JointStatusType js : jointStatuses.getJointStatus()) {
                            this.jogJointLabels[js.getJointNumber() - 1].setValue("Joint" + js.getJointNumber() + " " + String.format("%+6.1f ", js.getJointPosition()));
                        }
                    }
                }
                this.loadPoseToRotTable(pose, this.rotCurrentTable);
            }
            this.checkImageDirs();
        }
        catch (Property.ReadOnlyException | CRCLException | PmException ex) {
            Logger.getLogger(CrclClientUI.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void updateStateLabels(CommandStateEnumType state) {
        this.stateLbl.setValue("State: " + state);
        for (CommandStateEnumType stateToRemove : CommandStateEnumType.values()) {
            if (stateToRemove.equals((Object)state)) continue;
            this.stateLbl.removeStyleName(stateToRemove.toString());
            this.statusLabel.removeStyleName(stateToRemove.toString());
            this.stateDescriptionLbl.removeStyleName(stateToRemove.toString());
        }
        this.stateLbl.addStyleName(state.toString());
        this.statusLabel.addStyleName(state.toString());
        this.stateDescriptionLbl.addStyleName(state.toString());
    }

    public void loadPoseToRotTable(PoseType pose, Table rotTable) throws Property.ReadOnlyException {
        if (null != pose) {
            VectorType zAxis;
            VectorType xAxis = pose.getXAxis();
            if (null != xAxis) {
                Item xItem = rotTable.getItem((Object)"X");
                this.setAxisItem(xAxis, xItem);
            }
            if (null != (zAxis = pose.getZAxis())) {
                Item zItem = rotTable.getItem((Object)"Z");
                this.setAxisItem(zAxis, zItem);
            }
        }
    }

    public void setAxisItem(VectorType xAxis, Item xItem) throws Property.ReadOnlyException {
        xItem.getItemProperty((Object)"I").setValue((Object)xAxis.getI());
        xItem.getItemProperty((Object)"J").setValue((Object)xAxis.getJ());
        xItem.getItemProperty((Object)"K").setValue((Object)xAxis.getK());
    }

    public void readPoseFromRotTable(PoseType pose, Table rotTable) throws Property.ReadOnlyException {
        if (null == pose) {
            throw new IllegalArgumentException("pose may not be null");
        }
        VectorType xAxis = pose.getXAxis();
        if (null == xAxis) {
            xAxis = new VectorType();
            pose.setXAxis(xAxis);
        }
        Item xItem = rotTable.getItem((Object)"X");
        xAxis.setI(Double.valueOf(xItem.getItemProperty((Object)"I").getValue().toString()).doubleValue());
        xAxis.setJ(Double.valueOf(xItem.getItemProperty((Object)"J").getValue().toString()).doubleValue());
        xAxis.setK(Double.valueOf(xItem.getItemProperty((Object)"K").getValue().toString()).doubleValue());
        VectorType zAxis = pose.getZAxis();
        if (null == zAxis) {
            zAxis = new VectorType();
            pose.setZAxis(zAxis);
        }
        Item zItem = rotTable.getItem((Object)"Z");
        zAxis.setI(Double.valueOf(zItem.getItemProperty((Object)"I").getValue().toString()).doubleValue());
        zAxis.setJ(Double.valueOf(zItem.getItemProperty((Object)"J").getValue().toString()).doubleValue());
        zAxis.setK(Double.valueOf(zItem.getItemProperty((Object)"K").getValue().toString()).doubleValue());
    }

    public void checkImageDirs() {
        try {
            long last_modified;
            File[] dirSide;
            FileResource res;
            boolean deleted;
            File max_last_modified_File;
            long max_last_modified;
            File dirOverhead;
            if (null != tempDir) {
                int n;
                dirOverhead = overheadImageDir;
                max_last_modified = 0L;
                max_last_modified_File = null;
                if (dirOverhead.exists()) {
                    long last_modified2;
                    for (File f : dirOverhead.listFiles()) {
                        last_modified2 = f.lastModified();
                        if (max_last_modified >= last_modified2) continue;
                        max_last_modified = last_modified2;
                        max_last_modified_File = f;
                    }
                    File[] fileArray = dirOverhead.listFiles();
                    int n2 = fileArray.length;
                    for (n = 0; n < n2; ++n) {
                        File f;
                        f = fileArray[n];
                        last_modified2 = f.lastModified();
                        if (max_last_modified <= last_modified2 + 2000L || (deleted = f.delete())) continue;
                        LOGGER.warning(() -> f + " not deleted");
                    }
                    if (null != max_last_modified_File) {
                        res = new FileResource(max_last_modified_File);
                        this.access(() -> this.lambda$checkImageDirs$65((Resource)res));
                    }
                }
                dirSide = sideImageDir;
                max_last_modified = 0L;
                max_last_modified_File = null;
                if (dirSide.exists()) {
                    for (File f : dirSide.listFiles()) {
                        last_modified = f.lastModified();
                        if (max_last_modified >= last_modified) continue;
                        max_last_modified = last_modified;
                        max_last_modified_File = f;
                    }
                    File[] fileArray = dirSide.listFiles();
                    n = fileArray.length;
                    for (int f = 0; f < n; ++f) {
                        boolean deleted2;
                        File f2 = fileArray[f];
                        last_modified = f2.lastModified();
                        if (max_last_modified <= last_modified + 2000L || (deleted2 = f2.delete())) continue;
                        CrclClientUI.warning(() -> f2 + " not deleted");
                    }
                    if (null != max_last_modified_File) {
                        FileResource res2 = new FileResource(max_last_modified_File);
                        this.access(() -> this.lambda$checkImageDirs$67((Resource)res2));
                    }
                }
            }
            if (null != tempDir) {
                dirOverhead = transformGroupOverheadImageDir;
                max_last_modified = 0L;
                max_last_modified_File = null;
                if (dirOverhead.exists()) {
                    for (File f : dirOverhead.listFiles()) {
                        long last_modified3 = f.lastModified();
                        if (max_last_modified >= last_modified3) continue;
                        max_last_modified = last_modified3;
                        max_last_modified_File = f;
                    }
                    for (File f : dirOverhead.listFiles()) {
                        long last_modified4 = f.lastModified();
                        if (max_last_modified <= last_modified4 + 2000L || (deleted = f.delete())) continue;
                        CrclClientUI.warning(() -> f + " not deleted");
                    }
                    if (null != max_last_modified_File) {
                        res = new FileResource(max_last_modified_File);
                        this.access(() -> this.lambda$checkImageDirs$69((Resource)res));
                    }
                }
                dirSide = transformGroupSideImageDir;
                max_last_modified = 0L;
                max_last_modified_File = null;
                if (dirSide.exists()) {
                    for (File f : dirSide.listFiles()) {
                        last_modified = f.lastModified();
                        if (max_last_modified >= last_modified) continue;
                        max_last_modified = last_modified;
                        max_last_modified_File = f;
                    }
                    for (File f : dirSide.listFiles()) {
                        last_modified = f.lastModified();
                        if (max_last_modified <= last_modified + 2000L) continue;
                        f.delete();
                    }
                    if (null != max_last_modified_File) {
                        FileResource res2 = new FileResource(max_last_modified_File);
                        this.access(() -> this.lambda$checkImageDirs$70((Resource)res2));
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, null, e);
        }
    }

    private void runOneProgramStep(int new_program_index) throws CRCLException {
        int program_index = commonInfo.getProgramIndex();
        CRCLProgramType program = commonInfo.getCurrentProgram();
        this.instance.setCRCLCommand((CRCLCommandType)program.getMiddleCommand().get(program_index));
        this.instance.getCRCLCommand().setCommandID((long)(program_index + 2));
        this.lastCmdIdSent = this.instance.getCRCLCommand().getCommandID();
        this.instance.setProgramFile(commonInfo.getCurrentFileName());
        this.instance.setProgramIndex(Integer.valueOf(commonInfo.getProgramIndex()));
        this.instance.setProgramLength(Integer.valueOf(commonInfo.getCurrentProgram().getMiddleCommand().size()));
        this.socket.writeCommand(this.instance);
        CrclClientUI.setCommonInfo((CommonInfo)CommonInfo.withProgramIndex((CommonInfo)commonInfo, (int)new_program_index));
        this.skip_wait_for_done = false;
        if (new_program_index < program.getMiddleCommand().size() && new_program_index >= 0 && program.getMiddleCommand().get(new_program_index) instanceof MessageType) {
            MessageType msg = (MessageType)program.getMiddleCommand().get(new_program_index);
            String msgString = msg.getMessage();
            this.mySyncAccess(() -> {
                Notification n = new Notification("Program Paused to Show Message. Review the message to the right, then click Run to continue.");
                n.setDelayMsec(5000);
                n.show(Page.getCurrent());
                if (msgString.startsWith("http:") || msgString.startsWith("https:")) {
                    this.browser.setSource((Resource)new ExternalResource(msgString));
                } else {
                    this.browser.setSource((Resource)new StreamResource((StreamResource.StreamSource & Serializable)() -> new ByteArrayInputStream(("<html><body>" + msgString + "</body></html>").getBytes()), System.currentTimeMillis() + "msg.html"));
                }
                this.running = false;
                CrclClientUI.setCommonInfo((CommonInfo)CommonInfo.withProgramIndex((CommonInfo)commonInfo, (int)(new_program_index + 1)));
            });
            this.running = false;
        }
        this.mySyncAccess(() -> {
            Item item = this.progTable.getItem((Object)program_index);
            if (null != item) {
                this.programIndexLabel.setValue("Program Index :" + program_index);
                this.progTable.select((Object)program_index);
                this.progTable.setCurrentPageFirstItemId((Object)program_index);
            }
        });
    }

    public void detach() {
        CrclClientUI.removeProgramInfoListener((Consumer)this);
        this.disconnect();
        super.detach();
    }

    private /* synthetic */ void lambda$checkImageDirs$70(Resource res) {
        try {
            this.transformGroupSideImage.setSource(res);
            this.transformGroupSideImage.markAsDirty();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, null, e);
        }
    }

    private /* synthetic */ void lambda$checkImageDirs$69(Resource res) {
        try {
            this.transformGroupOverheadImage.setSource(res);
            this.transformGroupOverheadImage.markAsDirty();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, null, e);
        }
    }

    private /* synthetic */ void lambda$checkImageDirs$67(Resource res) {
        try {
            this.sideImage.setSource(res);
            this.sideImage.markAsDirty();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, null, e);
        }
    }

    private /* synthetic */ void lambda$checkImageDirs$65(Resource res) {
        try {
            this.overheadImage.setSource(res);
            this.overheadImage.markAsDirty();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, null, e);
        }
    }

    static /* synthetic */ ByteArrayOutputStream access$002(CrclClientUI x0, ByteArrayOutputStream x1) {
        x0.recieverOutputStream = x1;
        return x0.recieverOutputStream;
    }

    static /* synthetic */ ByteArrayOutputStream access$000(CrclClientUI x0) {
        return x0.recieverOutputStream;
    }

    static /* synthetic */ ProgramPlotter access$100() {
        return transformGroupOverheadPlotter;
    }

    static /* synthetic */ Slider access$200(CrclClientUI x0) {
        return x0.minXSlider;
    }

    static /* synthetic */ Slider access$300(CrclClientUI x0) {
        return x0.maxXSlider;
    }

    static /* synthetic */ Slider access$400(CrclClientUI x0) {
        return x0.minYSlider;
    }

    static /* synthetic */ Slider access$500(CrclClientUI x0) {
        return x0.maxYSlider;
    }

    static /* synthetic */ ProgramPlotter access$600() {
        return transformGroupSidePlotter;
    }

    static /* synthetic */ Slider access$700(CrclClientUI x0) {
        return x0.minZSlider;
    }

    static /* synthetic */ Slider access$800(CrclClientUI x0) {
        return x0.maxZSlider;
    }

    static /* synthetic */ CommonInfo access$900() {
        return commonInfo;
    }

    static /* synthetic */ File access$1000() {
        return REMOTE_PROGRAM_DIR;
    }

    static /* synthetic */ CRCLSocket access$1100(CrclClientUI x0) {
        return x0.socket;
    }

    static /* synthetic */ boolean access$1202(CrclClientUI x0, boolean x1) {
        x0.running = x1;
        return x0.running;
    }

    static /* synthetic */ void access$1300(CrclClientUI x0) {
        x0.connect();
    }

    static /* synthetic */ void access$1400(CrclClientUI x0, int x1) throws CRCLException {
        x0.runOneProgramStep(x1);
    }

    static /* synthetic */ String access$1502(CrclClientUI x0, String x1) {
        x0.selectedRemoteProgramFilename = x1;
        return x0.selectedRemoteProgramFilename;
    }

    static /* synthetic */ String access$1500(CrclClientUI x0) {
        return x0.selectedRemoteProgramFilename;
    }

    static /* synthetic */ void access$1600(CrclClientUI x0, File x1) {
        x0.setRemoteProgramResourceFile(x1);
    }

    static {
        imgcount = 0;
        lastGlobalPoseInImage = null;
        defaultBrowserResource = new StreamResource((StreamResource.StreamSource & Serializable)() -> new ByteArrayInputStream("<html><body>Message Panel</body></html>".getBytes()), System.currentTimeMillis() + "msg.html");
        tempDir = null;
        String tempDirProp = System.getProperty("temp.dir");
        if (!(tempDirProp == null || tempDirProp.length() <= 0 || (tempDir = new File(tempDirProp)).exists() && tempDir.isDirectory() && tempDir.canWrite())) {
            Logger.getLogger(CrclClientUI.class.getName()).log(Level.SEVERE, "Can't use tempDir from property temp.dir " + tempDir);
            tempDir = null;
        }
        if (null == tempDir) {
            try {
                File testTempFile = File.createTempFile("test", "suffix");
                tempDir = testTempFile.getParentFile();
            }
            catch (IOException ex) {
                Logger.getLogger(CrclClientUI.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        CrclClientUI.info(() -> "tempDir = " + tempDir);
        sideImageDir = new File(tempDir, "simserver/side");
        boolean made_side_dir = sideImageDir.mkdirs();
        Logger.getLogger(CrclClientUI.class.getName()).finest(() -> sideImageDir + "mkdirs() returned " + made_side_dir);
        CrclClientUI.info(() -> "sideImageDir = " + sideImageDir);
        for (File f : sideImageDir.listFiles()) {
            CrclClientUI.info(() -> "f = " + f);
            boolean deleted = f.delete();
            if (deleted) continue;
            CrclClientUI.warning(() -> f + " not deleted");
        }
        overheadImageDir = new File(tempDir, "simserver/overhead");
        boolean made_overhead_dir = overheadImageDir.mkdirs();
        Logger.getLogger(CrclClientUI.class.getName()).finest(() -> overheadImageDir + "mkdirs() returned " + made_overhead_dir);
        CrclClientUI.info(() -> "overheadImageDir = " + overheadImageDir);
        for (File f : overheadImageDir.listFiles()) {
            CrclClientUI.info(() -> "f = " + f);
            boolean deleted = f.delete();
            if (deleted) continue;
            CrclClientUI.warning(() -> f + " not deleted");
        }
        transformGroupSideImageDir = new File(tempDir, "transformGroup/side");
        boolean made_tg_dir = transformGroupSideImageDir.mkdirs();
        Logger.getLogger(CrclClientUI.class.getName()).finest(() -> transformGroupSideImageDir + "mkdirs() returned " + made_tg_dir);
        CrclClientUI.info(() -> "sideImageDir = " + transformGroupSideImageDir);
        for (File f : transformGroupSideImageDir.listFiles()) {
            CrclClientUI.info(() -> "f = " + f);
            boolean deleted = f.delete();
            if (deleted) continue;
            CrclClientUI.warning(() -> f + " not deleted");
        }
        transformGroupOverheadImageDir = new File(tempDir, "transformGroup/overhead");
        boolean made_tg_overhead_dir = transformGroupOverheadImageDir.mkdirs();
        Logger.getLogger(CrclClientUI.class.getName()).finest(() -> transformGroupOverheadImageDir + "mkdirs() returned " + made_tg_overhead_dir);
        for (File f : transformGroupSideImageDir.listFiles()) {
            boolean deleted = f.delete();
            if (deleted) continue;
            CrclClientUI.warning(() -> f + " not deleted");
        }
        transformGroupOverheadPlotter.setDimension(new Dimension(400, 400));
        transformGroupSidePlotter.setDimension(new Dimension(400, 400));
        browserMap = new HashMap();
        speedFraction = 0.1;
        jogWorldTransInc = 100.0;
        jogWorldRotInc = 100.0;
        globalCurrentPose = null;
        worldAngleIncrementRad = Math.toRadians(30.0);
        LOGGER = Logger.getLogger(CrclClientUI.class.getName());
    }
}

