/*
 * Decompiled with CFR 0.152.
 */
package crcl.vaadin.ui;

import crcl.base.CRCLProgramType;
import crcl.base.PointType;
import crcl.vaadin.ui.TransformInfo;

public class CommonInfo {
    private final String[] remotePrograms;
    private final String currentFileName;
    private final CRCLProgramType currentProgram;
    private final int programIndex;
    private final TransformInfo transformInfo;

    public String[] getRemotePrograms() {
        return this.remotePrograms;
    }

    public String getRemotePrograms(int index) {
        return this.remotePrograms[index];
    }

    public String getCurrentFileName() {
        return this.currentFileName;
    }

    public CRCLProgramType getCurrentProgram() {
        return this.currentProgram;
    }

    public TransformInfo getTransformInfo() {
        return this.transformInfo;
    }

    public int getProgramIndex() {
        return this.programIndex;
    }

    private CommonInfo(String[] remotePrograms, String currentFileName, CRCLProgramType currentProgram, int programIndex, TransformInfo transformInfo) {
        this.remotePrograms = remotePrograms;
        this.currentFileName = currentFileName;
        this.currentProgram = currentProgram;
        this.programIndex = programIndex;
        this.transformInfo = transformInfo;
    }

    public static CommonInfo defaultWithRemotePrograms(String[] remotePrograms) {
        return new CommonInfo(remotePrograms, "", new CRCLProgramType(), 0, TransformInfo.fromTwoPairsOfPoints());
    }

    public static CommonInfo withNewProgram(CommonInfo orig, String[] remotePrograms, String currentFileName, CRCLProgramType currentProgram) {
        return new CommonInfo(remotePrograms, currentFileName, currentProgram, 0, orig.getTransformInfo());
    }

    public static CommonInfo withRemotePrograms(CommonInfo orig, String[] remotePrograms) {
        return new CommonInfo(remotePrograms, orig.getCurrentFileName(), orig.getCurrentProgram(), orig.getProgramIndex(), orig.getTransformInfo());
    }

    public static CommonInfo withProgramIndex(CommonInfo orig, int programIndex) {
        return new CommonInfo(orig.getRemotePrograms(), orig.getCurrentFileName(), orig.getCurrentProgram(), programIndex, orig.getTransformInfo());
    }

    public static CommonInfo withTransformInfo(CommonInfo orig, TransformInfo transformInfo) {
        return new CommonInfo(orig.getRemotePrograms(), orig.getCurrentFileName(), orig.getCurrentProgram(), orig.getProgramIndex(), transformInfo);
    }

    public static CommonInfo withTransformInfoA1(CommonInfo orig, PointType a1) {
        return new CommonInfo(orig.getRemotePrograms(), orig.getCurrentFileName(), orig.getCurrentProgram(), orig.getProgramIndex(), TransformInfo.withA1((TransformInfo)orig.getTransformInfo(), (PointType)a1));
    }

    public static CommonInfo withTransformInfoA2(CommonInfo orig, PointType a2) {
        return new CommonInfo(orig.getRemotePrograms(), orig.getCurrentFileName(), orig.getCurrentProgram(), orig.getProgramIndex(), TransformInfo.withA2((TransformInfo)orig.getTransformInfo(), (PointType)a2));
    }

    public static CommonInfo withTransformInfoB1(CommonInfo orig, PointType b1) {
        return new CommonInfo(orig.getRemotePrograms(), orig.getCurrentFileName(), orig.getCurrentProgram(), orig.getProgramIndex(), TransformInfo.withB1((TransformInfo)orig.getTransformInfo(), (PointType)b1));
    }

    public static CommonInfo withTransformInfoB2(CommonInfo orig, PointType b2) {
        return new CommonInfo(orig.getRemotePrograms(), orig.getCurrentFileName(), orig.getCurrentProgram(), orig.getProgramIndex(), TransformInfo.withB2((TransformInfo)orig.getTransformInfo(), (PointType)b2));
    }
}

