/*
 * Decompiled with CFR 0.152.
 */
package com.github.wonwoo.dynamodb.test.autoconfigure;

import com.github.wonwoo.dynamodb.test.autoconfigure.DynamoTest;
import java.util.Collections;
import java.util.Set;
import org.springframework.boot.test.autoconfigure.filter.AnnotationCustomizableTypeExcludeFilter;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.annotation.AnnotatedElementUtils;

class DynamoTypeExcludeFilter
extends AnnotationCustomizableTypeExcludeFilter {
    private final DynamoTest annotation;

    DynamoTypeExcludeFilter(Class<?> testClass) {
        this.annotation = (DynamoTest)AnnotatedElementUtils.getMergedAnnotation(testClass, DynamoTest.class);
    }

    protected boolean hasAnnotation() {
        return this.annotation != null;
    }

    protected ComponentScan.Filter[] getFilters(AnnotationCustomizableTypeExcludeFilter.FilterType type) {
        switch (type) {
            case INCLUDE: {
                return this.annotation.includeFilters();
            }
            case EXCLUDE: {
                return this.annotation.excludeFilters();
            }
        }
        throw new IllegalStateException("Unsupported type " + type);
    }

    protected boolean isUseDefaultFilters() {
        return this.annotation.useDefaultFilters();
    }

    protected Set<Class<?>> getDefaultIncludes() {
        return Collections.emptySet();
    }

    protected Set<Class<?>> getComponentIncludes() {
        return Collections.emptySet();
    }
}

