/*
 * Decompiled with CFR 0.152.
 */
package com.wangjie.rapidrouter.compiler.base;

import com.google.auto.common.MoreElements;
import com.wangjie.rapidrouter.compiler.util.GlobalEnvironment;
import com.wangjie.rapidrouter.compiler.util.LogUtil;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public abstract class BaseAbstractProcessor
extends AbstractProcessor {
    protected Elements elementUtils;
    protected Types typeUtils;
    protected Filer filer;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        GlobalEnvironment.init(processingEnv);
        this.elementUtils = processingEnv.getElementUtils();
        this.typeUtils = processingEnv.getTypeUtils();
        this.filer = processingEnv.getFiler();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    protected void loggerE(Throwable throwable) {
        LogUtil.loggerE(throwable);
    }

    protected void logger(String str) {
        LogUtil.logger(str);
    }

    protected String getElementOwnerClassName(Element element) {
        String clazzName;
        ElementKind elementKind = element.getKind();
        if (ElementKind.FIELD == elementKind) {
            clazzName = MoreElements.asVariable((Element)element).getEnclosingElement().toString();
            this.logger("[getDIClazzSafe]MoreElements.asVariable().getEnclosingElement(): " + MoreElements.asVariable((Element)element).getEnclosingElement());
        } else {
            clazzName = ElementKind.METHOD == elementKind ? MoreElements.asExecutable((Element)element).getEnclosingElement().toString() : this.typeUtils.erasure(element.asType()).toString();
        }
        return clazzName;
    }

    protected Element getElementOwnerElement(Element element) {
        ElementKind elementKind = element.getKind();
        Element resultEle = ElementKind.FIELD == elementKind ? MoreElements.asVariable((Element)element).getEnclosingElement() : (ElementKind.METHOD == elementKind ? MoreElements.asExecutable((Element)element).getEnclosingElement() : element);
        return resultEle;
    }
}

