/*
 * Decompiled with CFR 0.152.
 */
package com.wangjie.rapidrouter.compiler;

import com.google.auto.service.AutoService;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import com.wangjie.rapidrouter.api.annotations.RRConfig;
import com.wangjie.rapidrouter.api.annotations.RRParam;
import com.wangjie.rapidrouter.api.annotations.RRUri;
import com.wangjie.rapidrouter.api.annotations.RRouter;
import com.wangjie.rapidrouter.compiler.base.BaseAbstractProcessor;
import com.wangjie.rapidrouter.compiler.objs.ParamEntry;
import com.wangjie.rapidrouter.compiler.objs.RouterEntry;
import com.wangjie.rapidrouter.compiler.objs.UriEntry;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;

@AutoService(value=Processor.class)
public class RouterProcessor
extends BaseAbstractProcessor {
    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> supportedTypesSet = new HashSet<String>();
        supportedTypesSet.add(RRConfig.class.getCanonicalName());
        supportedTypesSet.add(RRouter.class.getCanonicalName());
        supportedTypesSet.add(RRUri.class.getCanonicalName());
        return supportedTypesSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        block11: {
            long start = System.currentTimeMillis();
            this.logger("[process]annotations: " + Arrays.toString(annotations.toArray()));
            try {
                this.logger("roundEnv.getRootElements(): " + roundEnv.getRootElements());
                RouterEntry routerEntry = new RouterEntry();
                this.doPointAnnotation(roundEnv.getElementsAnnotatedWith(RRConfig.class), routerEntry);
                for (Element element : roundEnv.getElementsAnnotatedWith(RRouter.class)) {
                    this.doRouterAnnotation(element, routerEntry);
                }
                for (Element element : roundEnv.getElementsAnnotatedWith(RRUri.class)) {
                    this.doUriAnnotation(element, routerEntry);
                }
                if (routerEntry.getUriEntries().isEmpty()) break block11;
                try {
                    this.logger("RouterMapping generate START...");
                    routerEntry.brewJava().writeTo(this.filer);
                    this.logger("RouterMapping generate END...routerEntry: " + routerEntry);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable throwable) {
                    this.logger("RouterMapping generate FAILED...routerEntry: " + routerEntry);
                    this.loggerE(throwable);
                }
            }
            catch (Throwable throwable) {
                if (throwable instanceof RuntimeException) {
                    throw throwable;
                }
                this.loggerE(throwable);
            }
            finally {
                this.logger("[process] tasks: " + (System.currentTimeMillis() - start) + "ms");
            }
        }
        return true;
    }

    private void doPointAnnotation(Set<? extends Element> eles, RouterEntry routerEntry) {
        RRConfig rrConfig;
        String mappingClassName;
        int size;
        if (null == eles || 0 == (size = eles.size())) {
            return;
        }
        if (size != 1) {
            throw new RuntimeException("More than one Router Point Class Annotated @RRPoint.");
        }
        Element configEle = eles.iterator().next();
        String mappingPackage = this.elementUtils.getPackageOf(configEle).toString();
        if (null != mappingPackage && mappingPackage.length() > 0) {
            routerEntry.routerMappingPackage = mappingPackage;
        }
        if ((mappingClassName = (rrConfig = configEle.getAnnotation(RRConfig.class)).mappingName()).length() > 0) {
            routerEntry.routerMappingClassName = mappingClassName;
        }
    }

    private void doUriAnnotation(Element ele, RouterEntry routerEntry) {
        Element classEle = this.getElementOwnerElement(ele);
        if (null != classEle && !RRouter.class.getCanonicalName().equals(classEle.toString())) {
            List<UriEntry> uriEntries = routerEntry.getUriEntries();
            RRUri rrUri = ele.getAnnotation(RRUri.class);
            uriEntries.add(this.parseUriEntry(classEle, rrUri));
        }
    }

    private void doRouterAnnotation(Element ele, RouterEntry routerEntry) {
        Element classEle = this.getElementOwnerElement(ele);
        List<UriEntry> uriEntries = routerEntry.getUriEntries();
        RRouter rRouter = ele.getAnnotation(RRouter.class);
        for (RRUri rrUri : rRouter.value()) {
            uriEntries.add(this.parseUriEntry(classEle, rrUri));
        }
    }

    private UriEntry parseUriEntry(Element classEle, RRUri rrUri) {
        UriEntry uriEntry = new UriEntry();
        uriEntry.setRouterTargetClass(classEle);
        String uriStr = rrUri.uri();
        if (!uriStr.startsWith("~")) {
            URI uri = URI.create(uriStr);
            uriEntry.setScheme(uri.getScheme());
            uriEntry.setHost(uri.getHost());
        } else {
            uriEntry.setUriRegular(uriStr.substring(1));
        }
        List<ParamEntry> paramEntries = uriEntry.getParams();
        for (RRParam rrParam : rrUri.params()) {
            ParamEntry paramEntry = new ParamEntry();
            paramEntry.setName(rrParam.name());
            TypeMirror paramTypeMirror = RouterProcessor.getParamTypeMirror(rrParam);
            if (null == paramTypeMirror) {
                paramEntry.setType((TypeName)ClassName.get(String.class));
            } else {
                paramEntry.setType(ClassName.get((TypeMirror)paramTypeMirror));
            }
            paramEntries.add(paramEntry);
        }
        return uriEntry;
    }

    private static TypeMirror getParamTypeMirror(RRParam rrParam) {
        try {
            rrParam.type();
        }
        catch (MirroredTypeException mte) {
            return mte.getTypeMirror();
        }
        return null;
    }
}

