/*
 * Decompiled with CFR 0.152.
 */
package com.wangjie.rapidrouter.compiler.objs;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.wangjie.rapidrouter.compiler.objs.ParamEntry;
import com.wangjie.rapidrouter.compiler.objs.UriEntry;
import com.wangjie.rapidrouter.compiler.util.LogUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

public class RouterEntry {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:SSS");
    private List<UriEntry> uriEntries = new ArrayList<UriEntry>();
    public String routerMappingPackage;
    public String routerMappingClassName;

    public List<UriEntry> getUriEntries() {
        return this.uriEntries;
    }

    public JavaFile brewJava() throws Throwable {
        if (null == this.routerMappingPackage || this.routerMappingPackage.length() == 0 || null == this.routerMappingClassName || this.routerMappingClassName.length() == 0) {
            throw new RuntimeException("Have no Router Point Class  Annotated @RRPoint!");
        }
        TypeSpec.Builder result = TypeSpec.classBuilder((String)this.routerMappingClassName).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)ClassName.bestGuess((String)"com.wangjie.rapidrouter.core.RapidRouterMapping"));
        ClassName stringTypeName = ClassName.get(String.class);
        ClassName hashMapClassName = ClassName.get(HashMap.class);
        ClassName routerTargetTypeName = ClassName.bestGuess((String)"com.wangjie.rapidrouter.core.target.RouterTarget");
        ParameterizedTypeName simpleMapperTypeName = ParameterizedTypeName.get((ClassName)hashMapClassName, (TypeName[])new TypeName[]{stringTypeName, ParameterizedTypeName.get((ClassName)hashMapClassName, (TypeName[])new TypeName[]{stringTypeName, routerTargetTypeName})});
        ParameterizedTypeName regMapperTypeName = ParameterizedTypeName.get((ClassName)hashMapClassName, (TypeName[])new TypeName[]{stringTypeName, routerTargetTypeName});
        MethodSpec.Builder calcSimpleMapperMethodBuilder = MethodSpec.methodBuilder((String)"calcSimpleRouterMapper").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter((TypeName)simpleMapperTypeName, "routerMapper", new Modifier[0]).returns((TypeName)simpleMapperTypeName).addStatement("$T<$T, $T> params", new Object[]{hashMapClassName, stringTypeName, ClassName.get(Class.class)});
        MethodSpec.Builder calcRegMapperMethodBuilder = MethodSpec.methodBuilder((String)"calcRegRouterMapper").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter((TypeName)regMapperTypeName, "routerMapper", new Modifier[0]).returns((TypeName)regMapperTypeName).addStatement("$T<$T, $T> params", new Object[]{hashMapClassName, stringTypeName, ClassName.get(Class.class)});
        for (UriEntry uriEntry : this.uriEntries) {
            String uriRegular = uriEntry.getUriRegular();
            if (null == uriRegular || 0 == uriRegular.length()) {
                this.onSimpleMapperMethodStatement(hashMapClassName, (TypeName)routerTargetTypeName, calcSimpleMapperMethodBuilder, uriEntry);
                continue;
            }
            this.onRegularMapperMethodStatement(hashMapClassName, (TypeName)routerTargetTypeName, calcRegMapperMethodBuilder, uriEntry);
        }
        calcSimpleMapperMethodBuilder.addStatement("return $L", new Object[]{"routerMapper"});
        calcRegMapperMethodBuilder.addStatement("return $L", new Object[]{"routerMapper"});
        result.addMethod(calcSimpleMapperMethodBuilder.build());
        result.addMethod(calcRegMapperMethodBuilder.build());
        return JavaFile.builder((String)this.routerMappingPackage, (TypeSpec)result.build()).addFileComment("GENERATED CODE BY RapidRouter. DO NOT MODIFY! $S", new Object[]{DATE_FORMAT.format(new Date(System.currentTimeMillis()))}).skipJavaLangImports(true).build();
    }

    private void onSimpleMapperMethodStatement(ClassName hashMapClassName, TypeName routerTargetTypeName, MethodSpec.Builder calcSimpleMapperMethodBuilder, UriEntry uriEntry) {
        calcSimpleMapperMethodBuilder.addCode("// " + uriEntry.getRouterTargetClass() + "\n", new Object[0]);
        List<ParamEntry> paramEntries = uriEntry.getParams();
        if (null == paramEntries || paramEntries.size() <= 0) {
            calcSimpleMapperMethodBuilder.addStatement("getEnsureMap($L, $S).put($S, new $T($T.class, null))", new Object[]{"routerMapper", uriEntry.getScheme(), uriEntry.getHost(), routerTargetTypeName, ClassName.get((TypeMirror)uriEntry.getRouterTargetClass().asType())});
        } else {
            calcSimpleMapperMethodBuilder.addStatement("$L = new $T<>()", new Object[]{"params", hashMapClassName});
            for (ParamEntry paramEntry : paramEntries) {
                LogUtil.logger("[Simple]paramEntry: " + paramEntry);
                calcSimpleMapperMethodBuilder.addStatement("params.put($S, $T.class)", new Object[]{paramEntry.getName(), paramEntry.getType()});
            }
            calcSimpleMapperMethodBuilder.addStatement("getEnsureMap($L, $S).put($S, new $T($T.class, $L))", new Object[]{"routerMapper", uriEntry.getScheme(), uriEntry.getHost(), routerTargetTypeName, ClassName.get((TypeMirror)uriEntry.getRouterTargetClass().asType()), "params"});
        }
    }

    private void onRegularMapperMethodStatement(ClassName hashMapClassName, TypeName routerTargetTypeName, MethodSpec.Builder calcRegMapperMethodBuilder, UriEntry uriEntry) {
        calcRegMapperMethodBuilder.addCode("// " + uriEntry.getRouterTargetClass() + "\n", new Object[0]);
        List<ParamEntry> paramEntries = uriEntry.getParams();
        if (null == paramEntries || paramEntries.size() <= 0) {
            calcRegMapperMethodBuilder.addStatement("$L.put($S, new $T($T.class, null))", new Object[]{"routerMapper", uriEntry.getUriRegular(), routerTargetTypeName, ClassName.get((TypeMirror)uriEntry.getRouterTargetClass().asType())});
        } else {
            calcRegMapperMethodBuilder.addStatement("$L = new $T<>()", new Object[]{"params", hashMapClassName});
            for (ParamEntry paramEntry : paramEntries) {
                LogUtil.logger("[Reg]paramEntry: " + paramEntry);
                calcRegMapperMethodBuilder.addStatement("params.put($S, $T.class)", new Object[]{paramEntry.getName(), paramEntry.getType()});
            }
            calcRegMapperMethodBuilder.addStatement("$L.put($S, new $T($T.class, $L))", new Object[]{"routerMapper", uriEntry.getUriRegular(), routerTargetTypeName, ClassName.get((TypeMirror)uriEntry.getRouterTargetClass().asType()), "params"});
        }
    }
}

