/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output.elastic;

import com.google.common.base.Strings;
import com.googlecode.jmxtrans.model.output.elastic.ElasticBulkListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ElasticClientConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticClientConnection.class);
    private static final int ELASTIC_PORT = 9300;
    private final AtomicInteger refCount = new AtomicInteger(0);
    private final String host;
    private final TransportClient client;
    private final BulkProcessor processor;

    private ElasticClientConnection(String host, TransportClient client, BulkProcessor bulkProcessor) {
        this.host = host;
        this.client = client;
        this.processor = bulkProcessor;
    }

    void addRequest(IndexRequest indexRequest) {
        this.processor.add(indexRequest);
    }

    String getHost() {
        return this.host;
    }

    int reference() {
        return this.refCount.incrementAndGet();
    }

    int release() {
        int value = this.refCount.decrementAndGet();
        if (0 == value) {
            try {
                LOGGER.info("Flushing Elastic requests for {}.", (Object)this.client.transportAddresses());
                if (!this.processor.awaitClose(5L, TimeUnit.MINUTES)) {
                    LOGGER.warn("Some Elastic requests were still pending.");
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("An error occurred while flushing requests.", (Throwable)e);
            }
            LOGGER.info("Closing Elastic client for {}.", (Object)this.client.transportAddresses());
            this.client.close();
        }
        return value;
    }

    static ElasticClientConnection build(String elasticHostName, String clusterName, Map<String, Object> settings) {
        TransportClient elasticClient = ElasticClientConnection.createElasticClient(elasticHostName, clusterName);
        BulkProcessor elasticProcessor = ElasticClientConnection.createElasticProcessor((Client)elasticClient, settings);
        return new ElasticClientConnection(elasticHostName, elasticClient, elasticProcessor);
    }

    private static TransportClient createElasticClient(String elasticHostName, String clusterName) {
        LOGGER.info("Creating Elasticsearch client against {}:{} on cluster '{}'", new Object[]{elasticHostName, 9300, clusterName});
        try {
            InetAddress address = InetAddress.getByName(elasticHostName);
            PreBuiltTransportClient preBuiltTransportClient = null;
            if (!Strings.isNullOrEmpty((String)clusterName)) {
                Settings settings = Settings.builder().put("cluster.name", clusterName).put("client.transport.sniff", true).build();
                preBuiltTransportClient = new PreBuiltTransportClient(settings, new Class[0]);
            } else {
                preBuiltTransportClient = new PreBuiltTransportClient(Settings.EMPTY, new Class[0]);
            }
            return preBuiltTransportClient.addTransportAddress((TransportAddress)new InetSocketTransportAddress(address, 9300));
        }
        catch (UnknownHostException e) {
            LOGGER.error("Unknown host: {}", (Object)elasticHostName);
            return null;
        }
    }

    private static BulkProcessor createElasticProcessor(Client client, Map<String, Object> settings) {
        Integer maxBulkRequests = (Integer)settings.getOrDefault("maxBulkRequests", 5000);
        Integer maxBulkSize = (Integer)settings.getOrDefault("maxBulkSizeMB", 100);
        Integer maxBulkHoldSeconds = (Integer)settings.getOrDefault("maxBulkHoldSeconds", 15);
        Integer bulkBackoffWaitMillis = (Integer)settings.getOrDefault("bulkBackoffWaitMillis", 100);
        Integer maxBulkBackoffRetries = (Integer)settings.getOrDefault("maxBulkBackoffRetries", 3);
        Integer bulkConcurrency = (Integer)settings.getOrDefault("bulkConcurrency", 1);
        LOGGER.info("Creating processor: {} actions, {} concurrent, {}MB size, flush every {}s, backoff @ {}ms w/ {} retries.", new Object[]{maxBulkRequests, bulkConcurrency, maxBulkSize, maxBulkHoldSeconds, bulkBackoffWaitMillis, maxBulkBackoffRetries});
        return BulkProcessor.builder((Client)client, (BulkProcessor.Listener)new ElasticBulkListener()).setBulkActions(maxBulkRequests.intValue()).setBulkSize(new ByteSizeValue((long)maxBulkSize.intValue(), ByteSizeUnit.MB)).setFlushInterval(TimeValue.timeValueSeconds((long)maxBulkHoldSeconds.intValue())).setConcurrentRequests(bulkConcurrency.intValue()).setBackoffPolicy(BackoffPolicy.exponentialBackoff((TimeValue)TimeValue.timeValueMillis((long)bulkBackoffWaitMillis.intValue()), (int)maxBulkBackoffRetries)).build();
    }
}

