/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output.elastic;

import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ElasticBulkListener
implements BulkProcessor.Listener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticBulkListener.class);

    ElasticBulkListener() {
    }

    public void beforeBulk(long executionId, BulkRequest bulkRequest) {
        LOGGER.debug("Sending Elastic request #{} with {} actions and about {} bytes.", new Object[]{executionId, bulkRequest.numberOfActions(), bulkRequest.estimatedSizeInBytes()});
    }

    public void afterBulk(long executionId, BulkRequest bulkRequest, BulkResponse bulkResponse) {
        bulkResponse.forEach(r -> {
            if (r.isFailed()) {
                LOGGER.warn("Failed to insert documents: {} {}", (Object)r.getFailure(), (Object)r.getFailureMessage());
            }
        });
    }

    public void afterBulk(long executionId, BulkRequest bulkRequest, Throwable throwable) {
        LOGGER.warn("Failed to insert documents.", throwable);
    }
}

