/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output.elastic;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.googlecode.jmxtrans.exceptions.LifecycleException;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.ValidationException;
import com.googlecode.jmxtrans.model.output.BaseOutputWriter;
import com.googlecode.jmxtrans.model.output.elastic.ElasticClientConnection;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.elasticsearch.action.index.IndexRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticAggregateWriter
extends BaseOutputWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticAggregateWriter.class);
    private static final String DEFAULT_TYPE_NAME = "jmx-entry";
    private static final String DEFAULT_INDEX_NAME = "jmxtrans";
    private static final String DEFAULT_CLUSTER_NAME = "";
    private final String elasticTypeName;
    private final String elasticIndexName;
    private final String url;
    private final String clusterName;
    private final Map<String, Object> settingsMap;
    private ElasticClientConnection client;
    private static final Map<String, ElasticClientConnection> CONNECTIONS = new ConcurrentHashMap<String, ElasticClientConnection>();

    @JsonCreator
    public ElasticAggregateWriter(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="debug") Boolean debugEnabled, @JsonProperty(value="elasticHostName") String elasticHostName, @JsonProperty(value="elasticClusterName") String elasticClusterName, @JsonProperty(value="elasticIndexName") String elasticIndexName, @JsonProperty(value="elasticTypeName") String elasticTypeName, @JsonProperty(value="settings") Map<String, Object> settings) {
        super(typeNames, booleanAsNumber, debugEnabled, settings);
        this.settingsMap = ImmutableMap.copyOf((Map)((Map)MoreObjects.firstNonNull(settings, Collections.emptyMap())));
        this.elasticIndexName = (String)this.firstNonNull(elasticIndexName, (String)this.settingsMap.get("elasticIndexName"), DEFAULT_INDEX_NAME);
        this.elasticTypeName = (String)this.firstNonNull(elasticTypeName, (String)this.settingsMap.get("elasticTypeName"), DEFAULT_TYPE_NAME);
        this.url = (String)MoreObjects.firstNonNull((Object)elasticHostName, (Object)((String)this.settingsMap.get("elasticHostName")));
        this.clusterName = (String)this.firstNonNull(elasticClusterName, (String)this.settingsMap.get("elasticClusterName"), DEFAULT_CLUSTER_NAME);
    }

    public void start() throws LifecycleException {
        super.start();
        LOGGER.info("Starting Elasticsearch writer against {}/{}.", (Object)this.url, (Object)this.clusterName);
        this.client = CONNECTIONS.computeIfAbsent(this.url, u -> ElasticClientConnection.build(u, this.clusterName, this.settingsMap));
        if (null == this.client) {
            throw new LifecycleException("Can't start Elasticsearch writer: could not construct a client.");
        }
        this.client.reference();
    }

    public void close() throws LifecycleException {
        super.close();
        LOGGER.info("Stopping Elasticsearch client against {}/{}.", (Object)this.url, (Object)this.clusterName);
        if (null != this.client && this.client.release() == 0) {
            LOGGER.info("Discarding Elasticsearch client.");
            CONNECTIONS.remove(this.client.getHost());
        }
    }

    public void validateSetup(Server server, Query query) throws ValidationException {
    }

    protected void internalWrite(Server server, Query query, ImmutableList<Result> results) throws Exception {
        if (this.client == null) {
            return;
        }
        if (results.isEmpty()) {
            LOGGER.debug("Not processing empty query result.");
            return;
        }
        Map<String, List<Result>> resultsMap = results.stream().collect(Collectors.groupingBy(Result::getTypeName));
        LOGGER.debug("Query results: {}", resultsMap);
        resultsMap.forEach((t, r) -> this.write(server, (String)t, (List<Result>)r));
    }

    private void write(Server server, String typeName, List<Result> results) {
        HashMap<Object, Serializable> document = new HashMap<Object, Serializable>();
        HashMap<String, Object> metadata = new HashMap<String, Object>(6);
        String typeNameValues = this.getConcatedTypeNameValues(typeName);
        String indexName = String.format(this.elasticIndexName, Calendar.getInstance());
        metadata.put("serverAlias", server.getAlias());
        metadata.put("server", server.getHost());
        metadata.put("port", Integer.valueOf(server.getPort()));
        metadata.put("typeName", typeName);
        metadata.put("typeNameValues", typeNameValues);
        for (Result result : results) {
            metadata.putIfAbsent("className", result.getClassName());
            document.putIfAbsent("@timestamp", Long.valueOf(result.getEpoch()));
            ImmutableMap values = result.getValues();
            document.put(Optional.fromNullable((Object)result.getKeyAlias()).or((Object)result.getAttributeName()), (Serializable)(values.size() == 1 ? values.get((Object)result.getAttributeName()) : values));
        }
        document.put("@metadata", metadata);
        LOGGER.debug("Insert into Elastic index [{}] with type [{}]: {}", new Object[]{indexName, this.elasticTypeName, document});
        this.client.addRequest(new IndexRequest(indexName, this.elasticTypeName).source(document));
    }
}

