/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j.spring.boot.ext.utils;

import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.List;
import org.pf4j.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class PluginUtils {
    private static Logger logger = LoggerFactory.getLogger(PluginUtils.class);

    public static void loadAndStartPlugins(PluginManager pluginManager, List<String> plugins) {
        if (!CollectionUtils.isEmpty(plugins)) {
            ArrayList<String> pluginIds = new ArrayList<String>();
            for (String path : plugins) {
                try {
                    String pluginId = pluginManager.loadPlugin(FileSystems.getDefault().getPath(path, new String[0]));
                    if (!StringUtils.hasText((String)pluginId)) continue;
                    pluginIds.add(pluginId);
                    pluginManager.startPlugin(pluginId);
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
            try {
                for (String pluginId : pluginIds) {
                    if (!StringUtils.hasText((String)pluginId)) continue;
                    pluginManager.startPlugin(pluginId);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
    }
}

