/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j.spring.boot.ext.utils;

import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RestController;

public class InjectorUtils {
    public static boolean isController(Class<?> extensionClass) {
        RestController restController = extensionClass.getAnnotation(RestController.class);
        if (restController != null) {
            return true;
        }
        Controller controller = extensionClass.getAnnotation(Controller.class);
        return controller != null;
    }

    public static boolean isInjectNecessary(Class<?> extensionClass) {
        RestController restController = extensionClass.getAnnotation(RestController.class);
        if (restController != null) {
            return true;
        }
        Controller controller = extensionClass.getAnnotation(Controller.class);
        if (controller != null) {
            return true;
        }
        Component component = extensionClass.getAnnotation(Component.class);
        if (component != null && StringUtils.hasText((String)component.value())) {
            return true;
        }
        Service service = extensionClass.getAnnotation(Service.class);
        if (service != null) {
            return true;
        }
        Repository repository = extensionClass.getAnnotation(Repository.class);
        return repository != null && StringUtils.hasText((String)repository.value());
    }

    public static String getBeanName(Class<?> extensionClass, String defaultName) {
        RestController restController = extensionClass.getAnnotation(RestController.class);
        if (restController != null && StringUtils.hasText((String)restController.value())) {
            return restController.value();
        }
        Controller controller = extensionClass.getAnnotation(Controller.class);
        if (controller != null && StringUtils.hasText((String)controller.value())) {
            return controller.value();
        }
        Component component = extensionClass.getAnnotation(Component.class);
        if (component != null && StringUtils.hasText((String)component.value())) {
            return component.value();
        }
        Service service = extensionClass.getAnnotation(Service.class);
        if (service != null) {
            return service.value();
        }
        Repository repository = extensionClass.getAnnotation(Repository.class);
        if (repository != null && StringUtils.hasText((String)repository.value())) {
            return repository.value();
        }
        return defaultName;
    }
}

