/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j.spring.boot.ext.task;

import java.util.List;
import java.util.TimerTask;
import org.pf4j.PluginException;
import org.pf4j.PluginManager;
import org.pf4j.update.PluginInfo;
import org.pf4j.update.UpdateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginUpdateTask
extends TimerTask {
    private Logger logger = LoggerFactory.getLogger(PluginUpdateTask.class);
    private PluginManager pluginManager = null;
    private UpdateManager updateManager = null;

    public PluginUpdateTask(PluginManager pluginManager, UpdateManager updateManager) {
        this.pluginManager = pluginManager;
        this.updateManager = updateManager;
    }

    @Override
    public void run() {
        String lastVersion;
        PluginInfo.PluginRelease lastRelease;
        boolean systemUpToDate = true;
        if (this.updateManager.hasUpdates()) {
            List updates = this.updateManager.getUpdates();
            this.logger.debug("Found {} updates", (Object)updates.size());
            for (PluginInfo plugin : updates) {
                this.logger.debug("Found update for plugin '{}'", (Object)plugin.id);
                lastRelease = plugin.getLastRelease(this.pluginManager.getSystemVersion(), this.pluginManager.getVersionManager());
                lastVersion = lastRelease.version;
                String installedVersion = this.pluginManager.getPlugin(plugin.id).getDescriptor().getVersion();
                this.logger.debug("Update plugin '{}' from version {} to version {}", new Object[]{plugin.id, installedVersion, lastVersion});
                try {
                    boolean updated = this.updateManager.updatePlugin(plugin.id, lastVersion);
                    if (updated) {
                        this.logger.debug("Updated plugin '{}'", (Object)plugin.id);
                        continue;
                    }
                    this.logger.error("Cannot update plugin '{}'", (Object)plugin.id);
                    systemUpToDate = false;
                }
                catch (PluginException e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.logger.debug("No updates found");
        }
        if (this.updateManager.hasAvailablePlugins()) {
            List availablePlugins = this.updateManager.getAvailablePlugins();
            this.logger.debug("Found {} available plugins", (Object)availablePlugins.size());
            for (PluginInfo plugin : availablePlugins) {
                this.logger.debug("Found available plugin '{}'", (Object)plugin.id);
                lastRelease = plugin.getLastRelease(this.pluginManager.getSystemVersion(), this.pluginManager.getVersionManager());
                lastVersion = lastRelease.version;
                this.logger.debug("Install plugin '{}' with version {}", (Object)plugin.id, (Object)lastVersion);
                try {
                    boolean installed = this.updateManager.installPlugin(plugin.id, lastVersion);
                    if (installed) {
                        this.logger.debug("Installed plugin '{}'", (Object)plugin.id);
                        continue;
                    }
                    this.logger.error("Cannot install plugin '{}'", (Object)plugin.id);
                    systemUpToDate = false;
                }
                catch (PluginException e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.logger.debug("No available plugins found");
        }
        if (systemUpToDate) {
            this.logger.debug("System up-to-date");
        }
    }
}

