/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j.spring.boot.ext.registry;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.pf4j.spring.boot.ext.registry.DynamicControllerRegistry;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.PathMatcher;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class Pf4jDynamicControllerRegistry
implements DynamicControllerRegistry,
ApplicationContextAware {
    protected static Method detectHandlerMethodsMethod = ReflectionUtils.findMethod(RequestMappingHandlerMapping.class, (String)"detectHandlerMethods", (Class[])new Class[]{Object.class});
    protected static Method getMappingForMethodMethod = ReflectionUtils.findMethod(RequestMappingHandlerMapping.class, (String)"getMappingForMethod", (Class[])new Class[]{Method.class, Class.class});
    protected static Field mappingRegistryField = ReflectionUtils.findField(RequestMappingHandlerMapping.class, (String)"mappingRegistry");
    protected static Field injectionMetadataCacheField = ReflectionUtils.findField(AutowiredAnnotationBeanPostProcessor.class, (String)"injectionMetadataCache");
    @Autowired(required=false)
    protected RequestMappingHandlerMapping requestMappingHandlerMapping;
    protected AbstractAutowireCapableBeanFactory beanFactory;
    protected ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.beanFactory = (AbstractAutowireCapableBeanFactory)applicationContext.getAutowireCapableBeanFactory();
    }

    public Pf4jDynamicControllerRegistry() {
    }

    public Pf4jDynamicControllerRegistry(AbstractAutowireCapableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public void registerController(String beanName, Object controller) {
        Assert.notNull((Object)controller, (String)"controller must not null");
        beanName = StringUtils.isEmpty((Object)beanName) ? controller.getClass().getName() : beanName;
        this.removeRequestMappingIfNecessary(beanName);
        this.getBeanFactory().registerSingleton(beanName, controller);
        this.registerRequestMappingIfNecessary(beanName);
    }

    @Override
    public void removeController(String controllerBeanName) throws IOException {
        this.removeRequestMappingIfNecessary(controllerBeanName);
    }

    protected void removeRequestMappingIfNecessary(String controllerBeanName) {
        if (!this.getBeanFactory().containsBean(controllerBeanName)) {
            return;
        }
        RequestMappingHandlerMapping requestMappingHandlerMapping = this.getRequestMappingHandlerMapping();
        Class handlerType = this.getApplicationContext().getType(controllerBeanName);
        final Class userType = ClassUtils.getUserClass((Class)handlerType);
        Object mappingRegistry = ReflectionUtils.getField((Field)mappingRegistryField, (Object)requestMappingHandlerMapping);
        Method getMappingsMethod = ReflectionUtils.findMethod(mappingRegistry.getClass(), (String)"getMappings");
        getMappingsMethod.setAccessible(true);
        Map handlerMethods = (Map)ReflectionUtils.invokeMethod((Method)getMappingsMethod, (Object)mappingRegistry);
        Field urlLookupField = ReflectionUtils.findField(mappingRegistry.getClass(), (String)"urlLookup");
        urlLookupField.setAccessible(true);
        MultiValueMap urlMapping = (MultiValueMap)ReflectionUtils.getField((Field)urlLookupField, (Object)mappingRegistry);
        final RequestMappingHandlerMapping innerRequestMappingHandlerMapping = requestMappingHandlerMapping;
        Set methods = MethodIntrospector.selectMethods((Class)userType, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

            public boolean matches(Method method) {
                return ReflectionUtils.invokeMethod((Method)getMappingForMethodMethod, (Object)innerRequestMappingHandlerMapping, (Object[])new Object[]{method, userType}) != null;
            }
        });
        for (Method method : methods) {
            RequestMappingInfo requestMappingInfo = (RequestMappingInfo)ReflectionUtils.invokeMethod((Method)getMappingForMethodMethod, (Object)requestMappingHandlerMapping, (Object[])new Object[]{method, userType});
            handlerMethods.remove(requestMappingInfo);
            PatternsRequestCondition patternsCondition = requestMappingInfo.getPatternsCondition();
            Set patterns = patternsCondition.getPatterns();
            PathMatcher pathMatcher = requestMappingHandlerMapping.getPathMatcher();
            for (String pattern : patterns) {
                if (pathMatcher.isPattern(pattern)) continue;
                urlMapping.remove((Object)pattern);
            }
        }
    }

    protected void registerRequestMappingIfNecessary(String controllerBeanName) {
        RequestMappingHandlerMapping requestMappingHandlerMapping = this.getRequestMappingHandlerMapping();
        ReflectionUtils.invokeMethod((Method)detectHandlerMethodsMethod, (Object)requestMappingHandlerMapping, (Object[])new Object[]{controllerBeanName});
    }

    protected Map<String, InjectionMetadata> getInjectionMetadataCache() {
        AutowiredAnnotationBeanPostProcessor autowiredAnnotationBeanPostProcessor = (AutowiredAnnotationBeanPostProcessor)this.getApplicationContext().getBean(AutowiredAnnotationBeanPostProcessor.class);
        Map injectionMetadataMap = (Map)ReflectionUtils.getField((Field)injectionMetadataCacheField, (Object)autowiredAnnotationBeanPostProcessor);
        return injectionMetadataMap;
    }

    protected RequestMappingHandlerMapping getRequestMappingHandlerMapping() {
        try {
            if (this.requestMappingHandlerMapping != null) {
                return this.requestMappingHandlerMapping;
            }
            Map beans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.getApplicationContext(), RequestMappingHandlerMapping.class, (boolean)true, (boolean)false);
            if (!beans.isEmpty()) {
                ArrayList mappings = new ArrayList(beans.values());
                for (RequestMappingHandlerMapping handlerMapping : beans.values()) {
                    if (!handlerMapping.getClass().getName().equals(RequestMappingHandlerMapping.class.getName())) continue;
                    this.requestMappingHandlerMapping = handlerMapping;
                    return handlerMapping;
                }
                AnnotationAwareOrderComparator.sort(mappings);
                this.requestMappingHandlerMapping = (RequestMappingHandlerMapping)mappings.get(0);
                return this.requestMappingHandlerMapping;
            }
            this.requestMappingHandlerMapping = (RequestMappingHandlerMapping)this.getApplicationContext().getBean(RequestMappingHandlerMapping.class);
            return this.requestMappingHandlerMapping;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("applicationContext must has RequestMappingHandlerMapping");
        }
    }

    public AbstractAutowireCapableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(AbstractAutowireCapableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    static {
        detectHandlerMethodsMethod.setAccessible(true);
        getMappingForMethodMethod.setAccessible(true);
        mappingRegistryField.setAccessible(true);
        injectionMetadataCacheField.setAccessible(true);
    }
}

