/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j.spring.boot.ext;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.PostConstruct;
import org.pf4j.ExtensionFactory;
import org.pf4j.PluginManager;
import org.pf4j.spring.SingletonSpringExtensionFactory;
import org.pf4j.spring.SpringExtensionFactory;
import org.pf4j.spring.SpringPluginManager;
import org.pf4j.spring.boot.ext.ExtendedExtensionsInjector;
import org.pf4j.spring.boot.ext.registry.Pf4jDynamicControllerRegistry;
import org.springframework.beans.factory.annotation.Autowired;

public class ExtendedSpringPluginManager
extends SpringPluginManager {
    private boolean autowire = true;
    private boolean singleton = true;
    private boolean injectable = true;
    @Autowired
    private Pf4jDynamicControllerRegistry dynamicControllerRegistry;

    public ExtendedSpringPluginManager(File pluginsRoot, boolean autowire, boolean singleton, boolean injectable) {
        super(pluginsRoot.toPath());
        this.autowire = autowire;
        this.singleton = singleton;
        this.injectable = injectable;
    }

    public ExtendedSpringPluginManager(String pluginsRoot, boolean autowire, boolean singleton, boolean injectable) {
        super(Paths.get(pluginsRoot, new String[0]));
        this.autowire = autowire;
        this.singleton = singleton;
        this.injectable = injectable;
    }

    public ExtendedSpringPluginManager(Path pluginsRoot, boolean autowire, boolean singleton, boolean injectable) {
        super(pluginsRoot);
        this.autowire = autowire;
        this.singleton = singleton;
        this.injectable = injectable;
    }

    protected ExtensionFactory createExtensionFactory() {
        if (this.isSingleton()) {
            return new SingletonSpringExtensionFactory((PluginManager)this, this.isAutowire(), new String[0]);
        }
        return new SpringExtensionFactory((PluginManager)this, this.isAutowire());
    }

    @PostConstruct
    public void init() {
        this.loadPlugins();
        this.startPlugins();
        if (this.isInjectable()) {
            ExtendedExtensionsInjector extensionsInjector = new ExtendedExtensionsInjector((PluginManager)this, this.dynamicControllerRegistry, this.getApplicationContext());
            extensionsInjector.injectExtensions();
        }
    }

    public boolean isAutowire() {
        return this.autowire;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public boolean isInjectable() {
        return this.injectable;
    }
}

