/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j.spring.boot.ext;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.pf4j.DefaultExtensionFactory;
import org.pf4j.DefaultPluginManager;
import org.pf4j.ExtensionFactory;
import org.pf4j.PluginManager;
import org.pf4j.SingletonExtensionFactory;
import org.pf4j.spring.SingletonSpringExtensionFactory;
import org.pf4j.spring.SpringExtensionFactory;

public class ExtendedPluginManager
extends DefaultPluginManager {
    private boolean autowire = true;
    private boolean singleton = true;

    public ExtendedPluginManager(File pluginsRoot, boolean autowire, boolean singleton) {
        super(pluginsRoot.toPath());
        this.autowire = autowire;
        this.singleton = singleton;
    }

    public ExtendedPluginManager(String pluginsRoot, boolean autowire, boolean singleton) {
        super(Paths.get(pluginsRoot, new String[0]));
        this.autowire = autowire;
        this.singleton = singleton;
    }

    public ExtendedPluginManager(Path pluginsRoot, boolean autowire, boolean singleton) {
        super(pluginsRoot);
        this.autowire = autowire;
        this.singleton = singleton;
    }

    protected ExtensionFactory createExtensionFactory() {
        if (this.isAutowire()) {
            if (this.isSingleton()) {
                return new SingletonSpringExtensionFactory((PluginManager)this, true, new String[0]);
            }
            return new SpringExtensionFactory((PluginManager)this, true);
        }
        if (this.isSingleton()) {
            return new SingletonExtensionFactory(new String[0]);
        }
        return new DefaultExtensionFactory();
    }

    public boolean isAutowire() {
        return this.autowire;
    }

    public boolean isSingleton() {
        return this.singleton;
    }
}

