/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j.spring.boot.ext;

import org.pf4j.PluginManager;
import org.pf4j.spring.ExtensionsInjector;
import org.pf4j.spring.boot.ext.registry.Pf4jDynamicControllerRegistry;
import org.pf4j.spring.boot.ext.utils.InjectorUtils;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;

public class ExtendedExtensionsInjector
extends ExtensionsInjector {
    protected Pf4jDynamicControllerRegistry dynamicControllerRegistry;

    public ExtendedExtensionsInjector(PluginManager pluginManager, Pf4jDynamicControllerRegistry dynamicControllerRegistry, ApplicationContext applicationContext) {
        super(pluginManager, (AbstractAutowireCapableBeanFactory)applicationContext.getAutowireCapableBeanFactory());
        this.dynamicControllerRegistry = dynamicControllerRegistry;
    }

    protected void registerExtension(Class<?> extensionClass) {
        Object extension = this.pluginManager.getExtensionFactory().create(extensionClass);
        if (!InjectorUtils.isInjectNecessary(extensionClass)) {
            return;
        }
        String beanName = InjectorUtils.getBeanName(extensionClass, extension.getClass().getName());
        if (InjectorUtils.isController(extensionClass)) {
            this.dynamicControllerRegistry.registerController(beanName, extension);
        } else {
            this.beanFactory.registerSingleton(beanName, extension);
        }
    }
}

