/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j.spring.boot;

import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.pf4j.PluginDescriptor;
import org.pf4j.PluginManager;
import org.pf4j.PluginStateEvent;
import org.pf4j.PluginStateListener;
import org.pf4j.RuntimeMode;
import org.pf4j.spring.SpringPluginManager;
import org.pf4j.spring.boot.Pf4jProperties;
import org.pf4j.spring.boot.ext.ExtendedSpringPluginManager;
import org.pf4j.spring.boot.ext.registry.Pf4jDynamicControllerRegistry;
import org.pf4j.spring.boot.ext.task.PluginUpdateTask;
import org.pf4j.spring.boot.ext.update.DefaultUpdateRepositoryProvider;
import org.pf4j.spring.boot.ext.update.UpdateRepositoryProvider;
import org.pf4j.spring.boot.ext.utils.PluginUtils;
import org.pf4j.spring.boot.hooks.Pf4jShutdownHook;
import org.pf4j.update.UpdateManager;
import org.pf4j.update.UpdateRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={PluginManager.class, UpdateManager.class, SpringPluginManager.class})
@ConditionalOnProperty(prefix="spring.pf4j", value={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={Pf4jProperties.class})
public class Pf4jAutoConfiguration {
    private Logger logger = LoggerFactory.getLogger(Pf4jAutoConfiguration.class);
    private Timer timer = new Timer(true);

    @Bean
    @ConditionalOnMissingBean(value={Pf4jDynamicControllerRegistry.class})
    public Pf4jDynamicControllerRegistry pf4jDynamicControllerRegistry() {
        return new Pf4jDynamicControllerRegistry();
    }

    @Bean
    @ConditionalOnMissingBean(value={PluginStateListener.class})
    public PluginStateListener pluginStateListener() {
        return new PluginStateListener(){

            public void pluginStateChanged(PluginStateEvent event) {
                PluginDescriptor descriptor = event.getPlugin().getDescriptor();
                if (Pf4jAutoConfiguration.this.logger.isDebugEnabled()) {
                    Pf4jAutoConfiguration.this.logger.debug(String.format("Plugin [%s\uff08%s\uff09](%s) %s", descriptor.getPluginId(), descriptor.getVersion().toString(), descriptor.getPluginDescription(), event.getPluginState().toString()));
                }
            }
        };
    }

    @Bean
    public PluginManager pluginManager(Pf4jProperties properties) {
        RuntimeMode mode = RuntimeMode.byName((String)properties.getMode());
        System.setProperty("pf4j.mode", mode.toString());
        String pluginsRoot = StringUtils.hasText((String)properties.getPluginsRoot()) ? properties.getPluginsRoot() : "plugins";
        System.setProperty("pf4j.pluginsDir", pluginsRoot);
        String apphome = System.getProperty("app.home");
        if (RuntimeMode.DEPLOYMENT.compareTo((Enum)RuntimeMode.byName((String)properties.getMode())) == 0 && StringUtils.hasText((String)apphome)) {
            System.setProperty("pf4j.pluginsDir", apphome + File.separator + pluginsRoot);
        }
        ExtendedSpringPluginManager pluginManager = new ExtendedSpringPluginManager(pluginsRoot, properties.isAutowire(), properties.isSingleton(), properties.isInjectable());
        PluginUtils.loadAndStartPlugins((PluginManager)pluginManager, properties.getPlugins());
        Runtime.getRuntime().addShutdownHook(new Pf4jShutdownHook((PluginManager)pluginManager));
        return pluginManager;
    }

    @Bean
    @ConditionalOnMissingBean
    public UpdateRepositoryProvider updateRepositoryProvider(Pf4jProperties properties) {
        return new DefaultUpdateRepositoryProvider(properties.getRepos());
    }

    @Bean
    public UpdateManager updateManager(PluginManager pluginManager, UpdateRepositoryProvider updateRepositoryProvider, Pf4jProperties properties) {
        UpdateManager updateManager = null;
        List<UpdateRepository> repos = updateRepositoryProvider.getRepos();
        updateManager = StringUtils.hasText((String)properties.getReposJsonPath()) ? new UpdateManager(pluginManager, Paths.get(properties.getReposJsonPath(), new String[0])) : (!CollectionUtils.isEmpty(repos) ? new UpdateManager(pluginManager, repos) : new UpdateManager(pluginManager));
        if (properties.isAutoUpdate()) {
            this.timer.schedule((TimerTask)new PluginUpdateTask(pluginManager, updateManager), properties.getPeriod());
        }
        return updateManager;
    }
}

