package com.unbound.provider.kmip.response.dy;


import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.response.ResponseItem;

/**
 * Created by saar.peer on 28-Mar-17.
 */
public class DyRegisterClientResponse extends ResponseItem
{
    public int objectType = 0;
    public String name = "";

    public byte[] clientCertificate;
    public byte[] rootCaCertificate;

    public String partitionName;

    public DyRegisterClientResponse() {
        super(KMIP.Operation.DyRegister);
    }

    @Override
    public void convert(KMIPConverter converter) throws KMIPConvertException
    {
        name = converter.convert(KMIP.Tag.NameValue, name);
        objectType = converter.convert(KMIP.Tag.ObjectType, objectType);
        clientCertificate = converter.convert(KMIP.Tag.DyCertificate, clientCertificate);
        partitionName = converter.convert(KMIP.Tag.DyPartition, partitionName);
        rootCaCertificate = converter.convertOptional(KMIP.Tag.DyCaCertificate, rootCaCertificate);
    }
}
