package com.unbound.provider.kmip.response.dy;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.response.ResponseItem;

import java.util.ArrayList;

/**
 * Created by saar.peer on 04-Jun-17.
 */
public class DyLoginResponse extends ResponseItem
{
  public String partitionName;
  public ArrayList<Integer> allowedOperations = new ArrayList<>();
  public byte[] jwt;
  public byte[] refreshJwt;

  public String expiresAt;
  public int expiresIn;

  public DyLoginResponse()
  {
    super(KMIP.Operation.DyLogin);
  }

  @Override
  public void convert(KMIPConverter converter) throws KMIPConvertException
  {

    partitionName = converter.convert(KMIP.Tag.DyPartition, partitionName);
    jwt = converter.convertOptional(KMIP.Tag.AttestationAssertion, jwt);
    converter.convertIntList(KMIP.Tag.Operation, allowedOperations);

    //expiresAt = converter.convert(KMIP.Tag.jwtExpiresAt, expiresAt);
    //expiresIn = converter.convertOptional(KMIP.Tag.jwtExpiresIn, expiresIn);
  }
}
