package com.unbound.provider.kmip.response;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by saar.peer on 24-Jul-16.
 */
public class SignatureVerifyResponse extends ResponseItem
{
  public String uid = null;
  public int validityIndicator;

  public SignatureVerifyResponse()
  {
    super(KMIP.Operation.SignatureVerify);
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    uid = converter.convert(KMIP.Tag.UniqueIdentifier, uid);
    validityIndicator = converter.convert(KMIP.Tag.ValidityIndicator, validityIndicator);
  }

}
