package com.unbound.provider.kmip.response;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

import java.util.ArrayList;

/**
 * Created by valery.osheter on 19-Nov-15.
 */
public class ResponseMessage
{
  public ResponseHeader header = new ResponseHeader();

  public ArrayList<ResponseItem> batch = new ArrayList<>();

  public ResponseMessage()
  {
    header.version.major = 1;
    header.version.minor = 0;
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    int begin = converter.convertBegin(KMIP.Tag.ResponseMessage);
    header.convert(converter);
//    int count = converter.isWrite() ? batch.size() : header.batch_count;

    if (converter.isWrite())
    {
      for (ResponseItem item : batch) ResponseItem.convert(converter, item);
    }
    else
    {
      for (int i = 0; i < header.batchCount; i++)
      {
        ResponseItem item = ResponseItem.convert(converter, null);
        batch.add(item);
      }
    }

    converter.convertEnd(begin);
  }

  public void add(ResponseItem responseItem, byte[] uid)
  {

    if (responseItem.operation == KMIP.Operation.Poll)
    {
      if (((PollResponse) responseItem).responseItem != null)
      {
        add(((PollResponse) responseItem).responseItem);
        return;
      }
    }

    responseItem.responseUID = uid;
    batch.add(responseItem);
    header.batchCount++;
  }

  public void add(ResponseItem responseItem)
  {
    add(responseItem, null);
  }

  public void clear()
  {
    batch.clear();
    header.batchCount = 0;
  }
}
