package com.unbound.provider.kmip.response;

import com.unbound.common.HEX;
import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.response.dy.DyLoginResponse;
import com.unbound.provider.kmip.response.dy.DyRegisterClientResponse;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by valery.osheter on 19-Nov-15.
 */
public abstract class ResponseItem
{
  public int operation = 0;
  public byte[] responseUID = null;
  public int result_status = KMIP.ResultStatus.Success;
  public Integer reason = null;
  public String resultMsg = null;
  public byte[] asynch = null;

  private static final Map<Integer, Class<? extends ResponseItem>> registry = new HashMap<>();

  static
  {
    registry.put(0, FailureResponse.class);
    registry.put(KMIP.Operation.Create, CreateResponse.class);
    registry.put(KMIP.Operation.CreateKeyPair, CreateKeyPairResponse.class);
    registry.put(KMIP.Operation.Register, RegisterResponse.class);
    registry.put(KMIP.Operation.ReKey, ReKeyResponse.class);
    registry.put(KMIP.Operation.DeriveKey, DeriveResponse.class);
    registry.put(KMIP.Operation.ReCertify, CreateResponse.class);
    registry.put(KMIP.Operation.Locate, LocateResponse.class);
    registry.put(KMIP.Operation.Check, CheckResponse.class);
    registry.put(KMIP.Operation.Get, GetResponse.class);
    registry.put(KMIP.Operation.GetAttributes, GetAttributesResponse.class);
    registry.put(KMIP.Operation.GetAttributeList, GetAttributeListResponse.class);
    registry.put(KMIP.Operation.AddAttribute, AddAttributeResponse.class);
    registry.put(KMIP.Operation.ModifyAttribute, ModifyAttributeResponse.class);
    registry.put(KMIP.Operation.DeleteAttribute, DeleteAttributeResponse.class);
    registry.put(KMIP.Operation.Activate, ActivateResponse.class);
    registry.put(KMIP.Operation.Revoke, RevokeResponse.class);
    registry.put(KMIP.Operation.Destroy, DestroyResponse.class);
    registry.put(KMIP.Operation.Query, QueryResponse.class);
    registry.put(KMIP.Operation.Cancel, CancelResponse.class);
    registry.put(KMIP.Operation.Poll, PollResponse.class);
    registry.put(KMIP.Operation.ReKeyPair, ReKeyPairResponse.class);
    registry.put(KMIP.Operation.DiscoverVersions, DiscoverVersionsResponse.class);
    registry.put(KMIP.Operation.Encrypt, EncryptResponse.class);
    registry.put(KMIP.Operation.Decrypt, DecryptResponse.class);
    registry.put(KMIP.Operation.Sign, SignResponse.class);
    registry.put(KMIP.Operation.SignatureVerify, SignatureVerifyResponse.class);
    registry.put(KMIP.Operation.MAC, MACResponse.class);
    registry.put(KMIP.Operation.MACVerify, MACVerifyResponse.class);
    registry.put(KMIP.Operation.RNGRetrieve, RNGRetrieveResponse.class);
    registry.put(KMIP.Operation.RNGSeed, RNGSeedResponse.class);

    registry.put(KMIP.Operation.DyLogin, DyLoginResponse.class);
    registry.put(KMIP.Operation.DyRegister, DyRegisterClientResponse.class);
  }


  // used for storing result of quorum async operations, for example, storing the activation code
  // when executing create client with a quorum.
  // the value should be json serialized
  public String serializedResult = "";

  public ResponseItem(int _operation)
  {
    operation = _operation;
  }

  static public ResponseItem convert(KMIPConverter converter, ResponseItem item) throws KMIPConvertException
  {
    int begin = converter.convertBegin(KMIP.Tag.BatchItem);
    if (converter.isWrite())
    {
      if (item.operation != 0) converter.convert(KMIP.Tag.Operation, item.operation);
    }
    else
    {
      Integer operation = converter.convertOptional(KMIP.Tag.Operation, 0);
      if (operation == null) operation = 0;
      try { item = registry.get(operation).newInstance(); }
      catch (InstantiationException | IllegalAccessException e) { item = null; }
      if (item == null) KMIPConverter.setError("Unexpected response item for 0x" + HEX.toString(operation));
    }

    item.responseUID = converter.convertOptional(KMIP.Tag.UniqueBatchItemID, item.responseUID);
    item.result_status = converter.convert(KMIP.Tag.ResultStatus, item.result_status);
    item.reason = converter.convertOptional(KMIP.Tag.ResultReason, item.reason);
    item.resultMsg = converter.convertOptional(KMIP.Tag.ResultMessage, item.resultMsg);
    item.asynch = converter.convertOptional(KMIP.Tag.AsynchronousCorrelationValue, item.asynch);

    if (item.result_status == KMIP.ResultStatus.Success)
    {
      int payload_begin = converter.convertBegin(KMIP.Tag.ResponsePayload);
      item.convert(converter);
      converter.convertEnd(payload_begin);
    }

    converter.convertEnd(begin);
    return item;
  }

  public int getOperation()
  {
    return operation;
  }

  public abstract void convert(KMIPConverter converter) throws KMIPConvertException;

}
