package com.unbound.provider.kmip.response;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.Nonce;
import com.unbound.provider.kmip.attribute.Version;

/**
 * Created by valery.osheter on 19-Nov-15.
 */
public class ResponseHeader
{
  public Version version = new Version(1, 0);
  public long timeStamp = -1;
  public Nonce nonce = null;
  public int batchCount = 0;
  public String serverCorrelationValue;

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    int begin = converter.convertBegin(KMIP.Tag.ResponseHeader);
    version.convert(converter);
    timeStamp = converter.convert(KMIP.Tag.TimeStamp, timeStamp);

    if (converter.isRead() && converter.getNextTag() == KMIP.Tag.Nonce) nonce = new Nonce();
    if (nonce != null) nonce.convert(converter);

    if (converter.isRead())
    {
      converter.skip(KMIP.Tag.AttestationType);
    }

    if (version.major == 1 && version.minor == 4)
    {
      serverCorrelationValue = converter.convertOptional(KMIP.Tag.ServerCorrelationValue, serverCorrelationValue);
    }
    batchCount = converter.convert(KMIP.Tag.BatchCount, batchCount);
    converter.convertEnd(begin);
  }
}
