package com.unbound.provider.kmip.response;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.Attributes;
import com.unbound.provider.kmip.attribute.TemplateAttribute;

/**
 * Created by valery.osheter on 26-Nov-15.
 */
public class RegisterResponse extends ResponseItem
{
  public String uid = null;
  public TemplateAttribute template = null;
  public Attributes createdObjectAttrs;

  public RegisterResponse()
  {
    super(KMIP.Operation.Register);
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    uid = converter.convert(KMIP.Tag.UniqueIdentifier, uid);

    if (!converter.isWrite())
    {
      int tag = converter.getNextTag();
      if (tag == KMIP.Tag.CommonTemplateAttribute ||
              tag == KMIP.Tag.PrivateKeyTemplateAttribute ||
              tag == KMIP.Tag.PublicKeyTemplateAttribute ||
              tag == KMIP.Tag.TemplateAttribute) template = new TemplateAttribute();
    }

    if (template != null) template.convert(converter);
  }
}
