package com.unbound.provider.kmip.response;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.CapabilityInformation;
import com.unbound.provider.kmip.attribute.ExtInfo;
import com.unbound.provider.kmip.attribute.ServerInfo;

import java.util.ArrayList;

/**
 * Created by valery.osheter on 26-Nov-15.
 */
public class QueryResponse extends ResponseItem
{
  public ArrayList<Integer> operations = new ArrayList<>();
  public ArrayList<Integer> objectTypes = new ArrayList<>();
  public String vendorID = null;
  public ServerInfo serverInfo = null;
  public ArrayList<String> appNamespaces = new ArrayList<>();
  public ArrayList<ExtInfo> extInfos = new ArrayList<>();
  public ArrayList<Integer> attestationTypes = new ArrayList<>();
  public CapabilityInformation capabilityInfo = null;
  public ArrayList<Integer> clientRegistrationMethods = new ArrayList<>();

  public QueryResponse()
  {
    super(KMIP.Operation.Query);
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    converter.convertIntList(KMIP.Tag.Operation, operations);
    converter.convertIntList(KMIP.Tag.ObjectType, objectTypes);
    if (converter.isWrite() && serverInfo != null)
      vendorID = "unboundtech.com";
    vendorID = converter.convertOptional(KMIP.Tag.VendorIdentification, vendorID);

    if (converter.isRead() && converter.getNextTag() == KMIP.Tag.ServerInformation) serverInfo = new ServerInfo();
    if (serverInfo != null) serverInfo.convert(converter);

    converter.convertStrList(KMIP.Tag.ApplicationNamespace, appNamespaces);

    if (converter.isWrite()) for (ExtInfo extInfo : extInfos) extInfo.convert(converter);
    else
    {
      while (converter.getNextTag() == KMIP.Tag.ExtensionInformation)
      {
        ExtInfo extInfo = new ExtInfo();
        extInfo.convert(converter);
        extInfos.add(extInfo);
      }
    }
    converter.convertIntList(KMIP.Tag.AttestationType, attestationTypes);

    if (converter.isRead() && converter.getNextTag() == KMIP.Tag.CapabilityInformation)
      capabilityInfo = new CapabilityInformation();
    if (capabilityInfo != null) capabilityInfo.convert(converter);

    converter.convertIntList(KMIP.Tag.ClientRegistrationMethod, clientRegistrationMethods);
  }
}
