package com.unbound.provider.kmip.response;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by valery.osheter on 15-Dec-16.
 */
public class MACVerifyResponse extends ResponseItem
{
  public String uid = null;
  public byte[] corr = null;
  public int validityIndicator;

  public MACVerifyResponse()
  {
    super(KMIP.Operation.MACVerify);
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    uid = converter.convert(KMIP.Tag.UniqueIdentifier, uid);
    validityIndicator = converter.convert(KMIP.Tag.ValidityIndicator, validityIndicator);
    corr = converter.convertOptional(KMIP.Tag.CorrelationValue, corr);
  }
}

