package com.unbound.provider.kmip.response;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by valery.osheter on 15-Dec-16.
 */
public class MACResponse extends ResponseItem
{
  public String uid = null;
  public byte[] data = null;
  public byte[] corr = null;

  public MACResponse()
  {
    super(KMIP.Operation.MAC);
  }

  @Override
  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    uid = converter.convert(KMIP.Tag.UniqueIdentifier, uid);
    data = converter.convertOptional(KMIP.Tag.MACData, data);
    corr = converter.convertOptional(KMIP.Tag.CorrelationValue, corr);
  }
}
