package com.unbound.provider.kmip.response;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.TemplateAttribute;
import com.unbound.provider.kmip.object.ManagedObject;

/**
 * Created by valery.osheter on 29-Nov-15.
 */
public class GetResponse extends ResponseItem
{
  public String uid = null;
  public int objectType = 0;
  public TemplateAttribute template = null;
  public ManagedObject object;

  public GetResponse()
  {
    super(KMIP.Operation.Get);
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    objectType = converter.convert(KMIP.Tag.ObjectType, objectType);
    uid = converter.convert(KMIP.Tag.UniqueIdentifier, uid);

    if (!converter.isWrite())
    {
      int tag = converter.getNextTag();
      if (tag == KMIP.Tag.CommonTemplateAttribute ||
              tag == KMIP.Tag.PrivateKeyTemplateAttribute ||
              tag == KMIP.Tag.PublicKeyTemplateAttribute ||
              tag == KMIP.Tag.TemplateAttribute) template = new TemplateAttribute();
    }

    if (template != null) template.convert(converter);

    if (!converter.isWrite())
    {
      int tag = converter.getNextTag();
      object = ManagedObject.create(tag);
    }

    object.convert(converter);
  }
}
