package com.unbound.provider.kmip.response;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by valery.osheter on 26-Nov-15.
 */
public class GetAttributeListResponse extends ResponseItem
{
  public String uid = null;
  public List<String> names = new ArrayList<>();

  public GetAttributeListResponse()
  {
    super(KMIP.Operation.GetAttributeList);
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    uid = converter.convert(KMIP.Tag.UniqueIdentifier, uid);
    converter.convertStrList(KMIP.Tag.AttributeName, names);
  }
}
