package com.unbound.provider.kmip.response;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by saar.peer on 06-Nov-16.
 */
public class FailureResponse extends ResponseItem
{

  public String resultTitle = null;

  public FailureResponse()
  {
    super(0);
  }

  public FailureResponse(Integer resultReason, String message, String resultTitle)
  {
    this(resultReason, message, KMIP.ResultStatus.OperationFailed, resultTitle);
  }

  public FailureResponse(Integer resultReason, String message, int status, String resultTitle)
  {
    super(0);

    result_status = status;
    reason = resultReason;
    resultMsg = message;
    this.resultTitle = resultTitle;
  }

  @Override
  public void convert(KMIPConverter converter) throws KMIPConvertException
  {

  }
}
