package com.unbound.provider.kmip.response;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by saar.peer on 24-Jul-16.
 */
public class EncryptResponse extends ResponseItem
{
  public String uid = null;
  public byte[] data = null;
  public byte[] corr = null;
  public byte[] iv = null;
  public byte[] authEncTag = null;

  public EncryptResponse()
  {
    super(KMIP.Operation.Encrypt);
  }

  @Override
  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    uid = converter.convert(KMIP.Tag.UniqueIdentifier, uid);
    data = converter.convertOptional(KMIP.Tag.Data, data);
    iv = converter.convertOptional(KMIP.Tag.IVCounterNonce, iv);
    corr = converter.convertOptional(KMIP.Tag.CorrelationValue, corr);
    authEncTag = converter.convertOptional(KMIP.Tag.AuthenticatedEncryptionTag, authEncTag);
  }
}
