package com.unbound.provider.kmip.response;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.TemplateAttribute;

/**
 * Created by valery.osheter on 26-Mar-17.
 */
public class DeriveResponse extends ResponseItem
{

  public DeriveResponse()
  {
    super(KMIP.Operation.DeriveKey);
  }

  public String uid = null;
  public int objectType = 0;
  public TemplateAttribute template = null;

  @Override
  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    objectType = converter.convert(KMIP.Tag.ObjectType, objectType);
    uid = converter.convert(KMIP.Tag.UniqueIdentifier, uid);
    if (!converter.isWrite())
    {
      int tag = converter.getNextTag();
      if (tag == KMIP.Tag.CommonTemplateAttribute ||
              tag == KMIP.Tag.PrivateKeyTemplateAttribute ||
              tag == KMIP.Tag.PublicKeyTemplateAttribute ||
              tag == KMIP.Tag.TemplateAttribute) template = new TemplateAttribute();
    }
    if (template != null) template.convert(converter);
  }
}
