package com.unbound.provider.kmip.response;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by valery.osheter on 23-Nov-15.
 */
public class DecryptResponse extends ResponseItem
{
  public String uid = null;
  public byte[] data = null;
  public byte[] corr = null;

  public DecryptResponse()
  {
    super(KMIP.Operation.Decrypt);
  }

  @Override
  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    uid = converter.convert(KMIP.Tag.UniqueIdentifier, uid);
    data = converter.convertOptional(KMIP.Tag.Data, data);
    corr = converter.convertOptional(KMIP.Tag.CorrelationValue, corr);
  }
}
