package com.unbound.provider.kmip.response;


import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.TemplateAttribute;

/**
 * Created by valery.osheter on 26-Nov-15.
 */
public class CreateKeyPairResponse extends ResponseItem
{

  public String prvUID = "";

  public String pubUID = "";

  public TemplateAttribute common = null;
  public TemplateAttribute prv = null;
  public TemplateAttribute pub = null;

  public CreateKeyPairResponse()
  {
    super(KMIP.Operation.CreateKeyPair);
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    prvUID = converter.convert(KMIP.Tag.PrivateKeyUniqueIdentifier, prvUID);
    pubUID = converter.convert(KMIP.Tag.PublicKeyUniqueIdentifier, pubUID);

    if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.CommonTemplateAttribute)
      common = new TemplateAttribute();
    if (common != null)
    {
      common.tag = KMIP.Tag.CommonTemplateAttribute;
      common.convert(converter);
    }
    if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.PrivateKeyTemplateAttribute)
      prv = new TemplateAttribute();
    if (prv != null)
    {
      prv.tag = KMIP.Tag.PrivateKeyTemplateAttribute;
      prv.convert(converter);
    }
    if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.PublicKeyTemplateAttribute)
      pub = new TemplateAttribute();
    if (pub != null)
    {
      pub.tag = KMIP.Tag.PublicKeyTemplateAttribute;
      pub.convert(converter);
    }
  }
}
