package com.unbound.provider.kmip.response;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by valery.osheter on 23-Nov-15.
 */
public class CheckResponse extends ResponseItem
{
  public String uid = null;
  public Long usageLimitsCount = null;
  public Integer cryptoUsageMask = null;
  public Integer leaseTime = null;

  public CheckResponse()
  {
    super(KMIP.Operation.Check);
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    uid = converter.convert(KMIP.Tag.UniqueIdentifier, uid);
    usageLimitsCount = converter.convertOptional(KMIP.Tag.UsageLimitsCount, usageLimitsCount);
    cryptoUsageMask = converter.convertOptional(KMIP.Tag.CryptographicUsageMask, cryptoUsageMask);
    leaseTime = converter.convertOptional(KMIP.Tag.LeaseTime, leaseTime);
  }

}
