package com.unbound.provider.kmip.response;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.Attribute;

/**
 * Created by valery.osheter on 25-Nov-15.
 */
public class AddAttributeResponse extends ResponseItem
{

  public String uid = null;
  public Attribute attribute = null;

  public AddAttributeResponse()
  {
    super(KMIP.Operation.AddAttribute);
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    uid = converter.convertOptional(KMIP.Tag.UniqueIdentifier, uid);
    attribute = Attribute.convert(converter, attribute);
  }

}
