package com.unbound.provider.kmip.request.dy;


import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.request.RequestItem;

/**
 * Created by saar.peer on 28-Mar-17.
 */
public class DyRegisterClientRequest extends RequestItem
{
  public int objectType = 0;
  public String name = "";
  public String activationCode;
  public String partitionName;
  public byte[] csr;
  public String template;

  public DyRegisterClientRequest()
  {
    super(KMIP.Operation.DyRegister);
  }

  @Override
  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    name = converter.convert(KMIP.Tag.NameValue, name);
    objectType = converter.convert(KMIP.Tag.ObjectType, objectType);

    activationCode = converter.convertOptional(KMIP.Tag.DyActivationCode, activationCode);
    csr = converter.convert(KMIP.Tag.DyCertificateRequest, csr);
    partitionName = converter.convert(KMIP.Tag.DyPartition, partitionName);
    template = converter.convertOptional(KMIP.Tag.DyTemplate, template);
  }
}
