package com.unbound.provider.kmip.request;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.CryptoParams;

/**
 * Created by valery.osheter on 26-Nov-15.
 */
public class SignRequest extends RequestItem
{
  public SignRequest()
  {
    super(KMIP.Operation.Sign);
  }

  public String uid = null;
  public CryptoParams params = null;
  public byte[] data = null;
  public byte[] corr = null;
  public Boolean initInd = null;
  public Boolean finalInd = null;

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    uid = converter.convert(KMIP.Tag.UniqueIdentifier, uid);

    if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.CryptographicParameters)
      params = new CryptoParams();
    if (params != null) params.convertValue(converter);

    data = converter.convert(KMIP.Tag.Data, data);
    corr = converter.convertOptional(KMIP.Tag.CorrelationValue, corr);
    initInd = converter.convertOptional(KMIP.Tag.InitIndicator, initInd);
    finalInd = converter.convertOptional(KMIP.Tag.FinalIndicator, finalInd);
  }
}
