package com.unbound.provider.kmip.request;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.RevocationReason;

/**
 * Created by valery.osheter on 25-Nov-15.
 */
public class RevokeRequest extends RequestItem
{

  public String uid = null;
  public RevocationReason reason = new RevocationReason();
  public Long date = null;

  public RevokeRequest()
  {
    super(KMIP.Operation.Revoke);
  }

  public RevokeRequest(String uid, RevocationReason revocationReason)
  {
    this();
    this.uid = uid;
    this.reason = revocationReason;
  }

  @Override
  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    uid = converter.convertOptional(KMIP.Tag.UniqueIdentifier, uid);
    reason.convertValue(converter);
    date = converter.convertOptional(KMIP.Tag.CompromiseOccurrenceDate, date);
  }

}
