package com.unbound.provider.kmip.request;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

import java.util.ArrayList;
import java.util.stream.Collectors;

/**
 * Created by valery.osheter on 19-Nov-15.
 */
public class RequestMessage
{
  public RequestHeader header = new RequestHeader();

  public ArrayList<RequestItem> batch = new ArrayList<RequestItem>();

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    if (header.batch_count == 0) header.batch_count = batch.size();
    int begin = converter.convertBegin(KMIP.Tag.RequestMessage);
    header.convert(converter);
//      int count = converter.isWrite() ? batch.size() : header.batch_count;

    if (converter.isWrite())
    {
      for (RequestItem item : batch) RequestItem.convert(converter, item);
    }
    else
    {
      for (int i = 0; i < header.batch_count; i++)
      {
        RequestItem item = RequestItem.convert(converter, null);
        batch.add(item);
      }
    }

    converter.convertEnd(begin);
  }


}
