package com.unbound.provider.kmip.request;

import com.unbound.common.HEX;
import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.Attribute;
import com.unbound.provider.kmip.attribute.MessageExt;
import com.unbound.provider.kmip.request.dy.DyLoginRequest;
import com.unbound.provider.kmip.request.dy.DyRegisterClientRequest;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by valery.osheter on 19-Nov-15.
 */
public abstract class RequestItem
{
  public int operation = 0;
  public byte[] requestUID = null;
  public MessageExt ext = null;

  private static final Map<Integer, Class<? extends RequestItem>> registry = new HashMap<>();

  static
  {
    registry.put(KMIP.Operation.Create, CreateRequest.class);
    registry.put(KMIP.Operation.CreateKeyPair, CreateKeyPairRequest.class);
    registry.put(KMIP.Operation.Register, RegisterRequest.class);
    registry.put(KMIP.Operation.ReKey, ReKeyRequest.class);
    registry.put(KMIP.Operation.DeriveKey, DeriveRequest.class);
    registry.put(KMIP.Operation.ReCertify, CreateRequest.class);
    registry.put(KMIP.Operation.Locate, LocateRequest.class);
    registry.put(KMIP.Operation.Check, CheckRequest.class);
    registry.put(KMIP.Operation.Get, GetRequest.class);
    registry.put(KMIP.Operation.GetAttributes, GetAttributesRequest.class);
    registry.put(KMIP.Operation.GetAttributeList, GetAttributeListRequest.class);
    registry.put(KMIP.Operation.AddAttribute, AddAttributeRequest.class);
    registry.put(KMIP.Operation.ModifyAttribute, ModifyAttributeRequest.class);
    registry.put(KMIP.Operation.DeleteAttribute, DeleteAttributeRequest.class);
    registry.put(KMIP.Operation.Activate, ActivateRequest.class);
    registry.put(KMIP.Operation.Revoke, RevokeRequest.class);
    registry.put(KMIP.Operation.Destroy, DestroyRequest.class);
    registry.put(KMIP.Operation.Query, QueryRequest.class);
    registry.put(KMIP.Operation.Cancel, CancelRequest.class);
    registry.put(KMIP.Operation.Poll, PollRequest.class);
    registry.put(KMIP.Operation.ReKeyPair, ReKeyPairRequest.class);
    registry.put(KMIP.Operation.DiscoverVersions, DiscoverVersionsRequest.class);
    registry.put(KMIP.Operation.Encrypt, EncryptRequest.class);
    registry.put(KMIP.Operation.Decrypt, DecryptRequest.class);
    registry.put(KMIP.Operation.Sign, SignRequest.class);
    registry.put(KMIP.Operation.SignatureVerify, SignatureVerifyRequest.class);
    registry.put(KMIP.Operation.MAC, MACRequest.class);
    registry.put(KMIP.Operation.MACVerify, MACVerifyRequest.class);
    registry.put(KMIP.Operation.RNGRetrieve, RNGRetrieveRequest.class);
    registry.put(KMIP.Operation.RNGSeed, RNGSeedRequest.class);

    registry.put(KMIP.Operation.DyLogin, DyLoginRequest.class);
    registry.put(KMIP.Operation.DyRegister, DyRegisterClientRequest.class);
  }

  public RequestItem(int _operation)
  {
    operation = _operation;
  }

  public static RequestItem convert(KMIPConverter converter, RequestItem item) throws KMIPConvertException
  {
    int begin = converter.convertBegin(KMIP.Tag.BatchItem);
    int operation = converter.isWrite() ? item.operation : 0;
    operation = converter.convert(KMIP.Tag.Operation, operation);
    if (!converter.isWrite())
    {
      try { item = registry.get(operation).newInstance(); }
      catch (InstantiationException | IllegalAccessException e) { item = null; }
      if (item == null) KMIPConverter.setError("Unexpected request item for 0x" + HEX.toString(operation));
    }

    item.requestUID = converter.convertOptional(KMIP.Tag.UniqueBatchItemID, item.requestUID);
    int payload_begin = converter.convertBegin(KMIP.Tag.RequestPayload);
    item.convert(converter);
    converter.convertEnd(payload_begin);

    if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.MessageExtension) item.ext = new MessageExt();
    if (item.ext != null) item.ext.convert(converter);
    converter.convertEnd(begin);
    return item;
  }

  public abstract void convert(KMIPConverter converter) throws KMIPConvertException;


  public String getName()
  {
    return this.getClass().getSimpleName().replace("Request", "");
  }

  public int getOperation()
  {
    return operation;
  }
}
