package com.unbound.provider.kmip.request;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.Authentication;
import com.unbound.provider.kmip.attribute.Version;

/**
 * Created by valery.osheter on 19-Nov-15.
 */
public class RequestHeader
{

  public Version version = new Version(1, 0);

  public Integer max_response_size = null;
  public Boolean asynch = null;
  public Authentication auth = null;
  public Integer batch_continue = null;
  public Boolean batch_order = null;
  public Long time_stamp = null;
  public int batch_count;
  public String ClientCorrelationValue;

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    int begin = converter.convertBegin(KMIP.Tag.RequestHeader);
    version.convert(converter);
    max_response_size = converter.convertOptional(KMIP.Tag.MaximumResponseSize, max_response_size);
    asynch = converter.convertOptional(KMIP.Tag.AsynchronousIndicator, asynch);

    if (!converter.isWrite())
    {
      converter.convertOptional(KMIP.Tag.AttestationCapableIndicator, (Boolean) null);
    }

    if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.Authentication) auth = new Authentication();
    if (auth != null) auth.convert(converter);


    batch_continue = converter.convertOptional(KMIP.Tag.BatchErrorContinuationOption, batch_continue);
    batch_order = converter.convertOptional(KMIP.Tag.BatchOrderOption, batch_order);
    time_stamp = converter.convertOptional(KMIP.Tag.TimeStamp, time_stamp);
    ClientCorrelationValue = converter.convertOptional(KMIP.Tag.ClientCorrelationValue, ClientCorrelationValue);
    batch_count = converter.convert(KMIP.Tag.BatchCount, batch_count);
    converter.convertEnd(begin);
  }


}
