package com.unbound.provider.kmip.request;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.TemplateAttribute;
import com.unbound.provider.kmip.object.ManagedObject;

/**
 * Created by valery.osheter on 29-Nov-15.
 */
public class RegisterRequest extends RequestItem
{

  public int objectType = 0;

  public TemplateAttribute template = null;

  public ManagedObject object = null;

  public RegisterRequest()
  {
    super(KMIP.Operation.Register);
  }

  public RegisterRequest(ManagedObject object)
  {
    this();
    this.objectType = object.getKMIPObjectType();
    this.object = object;
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    objectType = converter.convert(KMIP.Tag.ObjectType, objectType);

    if (!converter.isWrite())
    {
      int tag = converter.getNextTag();
      if (tag == KMIP.Tag.CommonTemplateAttribute ||
              tag == KMIP.Tag.PrivateKeyTemplateAttribute ||
              tag == KMIP.Tag.PublicKeyTemplateAttribute ||
              tag == KMIP.Tag.TemplateAttribute) template = new TemplateAttribute();
    }

    if (template != null) template.convert(converter);

    if (!converter.isWrite())
    {
      int tag = converter.getNextTag();
      object = ManagedObject.create(tag);
    }

    object.convert(converter);
  }
}
