package com.unbound.provider.kmip.request;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.TemplateAttribute;

/**
 * Created by saar.peer on 15-Feb-17.
 */
public class ReKeyRequest extends RequestItem
{
  public String uid = null;
  public Integer offset = null;
  public TemplateAttribute template = null;

  public ReKeyRequest()
  {
    super(KMIP.Operation.ReKey);
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    uid = converter.convertOptional(KMIP.Tag.PrivateKeyUniqueIdentifier, uid);
    offset = converter.convertOptional(KMIP.Tag.Offset, offset);

    if (!converter.isWrite())
    {
      int tag = converter.getNextTag();
      if (tag == KMIP.Tag.CommonTemplateAttribute ||
              tag == KMIP.Tag.PrivateKeyTemplateAttribute ||
              tag == KMIP.Tag.PublicKeyTemplateAttribute ||
              tag == KMIP.Tag.TemplateAttribute) template = new TemplateAttribute();
    }

    if (template != null) template.convert(converter);
  }
}
