package com.unbound.provider.kmip.request;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.TemplateAttribute;

/**
 * Created by saar.peer on 16-Feb-17.
 */
public class ReKeyPairRequest extends RequestItem
{

  public String uid = null;
  public Integer offset = null;
  public TemplateAttribute common = null;
  public TemplateAttribute prv = null;
  public TemplateAttribute pub = null;

  public ReKeyPairRequest()
  {
    super(KMIP.Operation.ReKeyPair);
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    uid = converter.convertOptional(KMIP.Tag.PrivateKeyUniqueIdentifier, uid);
    offset = converter.convertOptional(KMIP.Tag.Offset, offset);


    if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.CommonTemplateAttribute)
      common = new TemplateAttribute();
    if (common != null)
    {
      common.tag = KMIP.Tag.CommonTemplateAttribute;
      common.convert(converter);
    }
    if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.PrivateKeyTemplateAttribute)
      prv = new TemplateAttribute();
    if (prv != null)
    {
      prv.tag = KMIP.Tag.PrivateKeyTemplateAttribute;
      prv.convert(converter);
    }
    if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.PublicKeyTemplateAttribute)
      pub = new TemplateAttribute();
    if (pub != null)
    {
      pub.tag = KMIP.Tag.PublicKeyTemplateAttribute;
      pub.convert(converter);
    }

  }
}
